/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.service.gw;

import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsHttpEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.DeploymentServiceAware;

@Named(value="mule.agent.gw.http.service")
@Singleton
public class AgentGwHttpMetricService
extends ConfigurableAgentService
implements DeploymentServiceAware {
    private static final Logger LOGGER = LogManager.getLogger(AgentGwHttpMetricService.class);
    static final String ANALYTICS_QUEUE_NAME = "_analyticsQueue";
    static final String ANALYTICS_POLICY_VIOLATION_QUEUE_NAME = "_analyticsPolicyViolationQueue";
    static final String POLL_BATCH_SIZE_DEFAULT = "50000";
    @Inject
    Set<InternalMessageHandler<AnalyticsHttpEvent>> internalHandlers;
    private DeploymentService deploymentService;
    private ClassLoader originalClassLoader;
    private AgentGWDeploymentListener deploymentListener = new AgentGWDeploymentListener();
    @Configurable(type=Type.DYNAMIC, value="5", description="Frequency used to publish information, by default 5 seconds")
    Integer pollingFrequency;
    @Configurable(type=Type.DYNAMIC, value="SECONDS", description="Time unit for the frequency, by default seconds")
    TimeUnit frequencyTimeUnit;
    @Configurable(type=Type.DYNAMIC, value="50000", description="Batch poll size for event queue retrieval")
    long pollBatchSize;
    private ScheduledExecutorService executor;
    private Queue analyticsQueue;
    private Queue policyViolationQueue;
    private AnalyticsConsumerRunnable analyticsConsumer;
    private AnalyticsConsumerRunnable policyConsumer;

    protected void doStart() throws MuleException {
        if (this.analyticsConsumer == null && this.policyConsumer == null) {
            if (this.pollBatchSize <= 0L) {
                LOGGER.warn("Minimum value for batch size is 1, value specified was {}, setting will be defaulted to {}", (Object)this.pollBatchSize, (Object)POLL_BATCH_SIZE_DEFAULT);
                this.pollBatchSize = Long.parseLong(POLL_BATCH_SIZE_DEFAULT);
            }
            this.setOriginalClassLoader(Thread.currentThread().getContextClassLoader());
            LOGGER.info("DoStart (before runConsumers) - ClassLoader: {} ", (Object)this.getOriginalClassLoader());
            this.runConsumers();
        }
    }

    protected void doStop() throws MuleException {
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.analyticsConsumer = null;
        this.policyConsumer = null;
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return new ArrayList<InternalMessageHandler>(this.internalHandlers);
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
        if (deploymentService != null) {
            this.deploymentService.addDeploymentListener((DeploymentListener)this.deploymentListener);
        }
    }

    private void setContextClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            LOGGER.error("setContextClassLoader - ClassLoader: {}. Could not switch ClassLoader is null. ", (Object)Thread.currentThread().getContextClassLoader());
        }
    }

    private void setOriginalClassLoader(ClassLoader originalClassLoader) {
        this.originalClassLoader = originalClassLoader;
    }

    public ClassLoader getOriginalClassLoader() {
        return this.originalClassLoader;
    }

    private void runConsumers() {
        if (this.analyticsQueue != null && this.policyViolationQueue != null) {
            LOGGER.info("RunConsumers - ClassLoader: {} ", (Object)Thread.currentThread().getContextClassLoader());
            this.executor = Executors.newScheduledThreadPool(2);
            this.analyticsConsumer = new AnalyticsConsumerRunnable(this.analyticsQueue);
            this.policyConsumer = new AnalyticsConsumerRunnable(this.policyViolationQueue);
            this.executor.scheduleAtFixedRate(this.analyticsConsumer, 0L, this.pollingFrequency.intValue(), this.frequencyTimeUnit);
            this.executor.scheduleAtFixedRate(this.policyConsumer, 0L, this.pollingFrequency.intValue(), this.frequencyTimeUnit);
        }
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    private class AgentGWDeploymentListener
    implements DeploymentListener {
        private AgentGWDeploymentListener() {
        }

        public void onArtifactInitialised(String artifactName, Registry registry) {
            if (AgentGwHttpMetricService.this.analyticsQueue == null && AgentGwHttpMetricService.this.policyViolationQueue == null) {
                AgentGwHttpMetricService.this.analyticsQueue = registry.lookupByName(AgentGwHttpMetricService.ANALYTICS_QUEUE_NAME).orElseGet(() -> {
                    LOGGER.debug("Analytics Queue null on artifact initialised notification for application {}.", (Object)artifactName);
                    return null;
                });
                AgentGwHttpMetricService.this.policyViolationQueue = registry.lookupByName(AgentGwHttpMetricService.ANALYTICS_POLICY_VIOLATION_QUEUE_NAME).orElseGet(() -> {
                    LOGGER.debug("Analytics Policy Violation Queue null on artifact initialised notification for application {}.", (Object)artifactName);
                    return null;
                });
                if (AgentGwHttpMetricService.this.isEnabled()) {
                    ClassLoader onArtifactInitialisedClassLoader = Thread.currentThread().getContextClassLoader();
                    AgentGwHttpMetricService.this.setContextClassLoader(AgentGwHttpMetricService.this.getOriginalClassLoader());
                    AgentGwHttpMetricService.this.runConsumers();
                    AgentGwHttpMetricService.this.setContextClassLoader(onArtifactInitialisedClassLoader);
                }
            }
        }
    }

    private class AnalyticsConsumerRunnable
    implements Runnable {
        private Queue<AnalyticsHttpEvent> queue;

        private AnalyticsConsumerRunnable(Queue<AnalyticsHttpEvent> queue) {
            this.queue = queue;
        }

        @Override
        public void run() {
            if (this.queue.isEmpty()) {
                LOGGER.trace("Analytics event queue is empty, skipping run.");
                return;
            }
            boolean anyEnabled = CollectionUtils.exists(AgentGwHttpMetricService.this.internalHandlers, o -> o.isEnabled());
            if (!anyEnabled) {
                LOGGER.debug("Skipping the Analytics event queue consumption since there is no Internal Handler enabled for relay.");
                return;
            }
            ArrayList<AnalyticsHttpEvent> events = new ArrayList<AnalyticsHttpEvent>();
            while ((long)events.size() < AgentGwHttpMetricService.this.pollBatchSize && this.queue.peek() != null) {
                AnalyticsHttpEvent event = this.queue.poll();
                events.add(event);
            }
            LOGGER.trace("Attempting to send {} events to Internal Handlers. ClassLoader: {} .", (Object)Long.toString(events.size()), (Object)Thread.currentThread().getContextClassLoader());
            for (InternalMessageHandler<AnalyticsHttpEvent> handler : AgentGwHttpMetricService.this.internalHandlers) {
                if (!handler.isEnabled()) continue;
                LOGGER.trace("Sending events {} to the {} Internal Handler. ", (Object)events.size(), handler);
                try {
                    for (AnalyticsHttpEvent queuedEvent : events) {
                        handler.handle((Object)queuedEvent);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("There was an error sending to the the events to the Internal Handler {}. ClassLoader: {}", handler, (Object)Thread.currentThread().getContextClassLoader());
                    LOGGER.debug((Object)e);
                }
            }
        }
    }
}

