/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.rendering.internal;

import net.jeeeyul.swtend.SWTExtensions;
import net.jeeeyul.swtend.ui.NinePatch;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class Shadow9PatchFactory {
    private static ImageData blur(ImageData src, int radius) {
        ImageData dest = new ImageData(src.width, src.height, src.depth, src.palette);
        int x = 0;
        while (x < src.width) {
            int y = 0;
            while (y < src.height) {
                dest.setPixel(x, y, src.getPixel(x, y));
                double a = 0.0;
                int dx = -1;
                while (dx <= 1) {
                    int dy = -1;
                    while (dy <= 1) {
                        int rx = x + dx;
                        int ry = y + dy;
                        a += (double)Shadow9PatchFactory.getAlpha(src, rx, ry);
                        ++dy;
                    }
                    ++dx;
                }
                dest.setAlpha(x, y, Shadow9PatchFactory.limit(a / 9.0));
                ++y;
            }
            ++x;
        }
        return dest;
    }

    public static NinePatch createShadowPatch(RGB foreground, int radius, int shadowRadius) {
        radius = Math.max(radius, 5);
        shadowRadius = Math.max(shadowRadius, 1);
        Rectangle shadow = new Rectangle(0, 0, radius * 3 + shadowRadius * 2, radius * 3 + shadowRadius * 2);
        Rectangle shadowShape = SWTExtensions.INSTANCE.getShrinked(shadow, shadowRadius);
        ImageData shadowData = Shadow9PatchFactory.generateShadowImageData(shadow.width, shadow.height, shadowShape, radius, foreground, shadowRadius);
        NinePatch patch = new NinePatch(shadowData, SWTExtensions.INSTANCE.getShrinked(shadowShape, radius), false);
        return patch;
    }

    private static void fill(ImageData data, int x, int y, int w, int h, RGB color, int radius, int alpha) {
        Rectangle topLeft = new Rectangle(x, y, radius, radius);
        Rectangle topRight = new Rectangle(x + w - radius, y, radius, radius);
        Rectangle bottomLeft = new Rectangle(x, y + h - radius, radius, radius);
        Rectangle bottomRight = new Rectangle(x + w - radius, y + h - radius, radius, radius);
        if (radius > 0) {
            int cx = x;
            while (cx < x + w) {
                int cy = y;
                while (cy < y + h) {
                    int oy;
                    int ox;
                    if (SWTExtensions.INSTANCE.contains(topLeft, cx, cy)) {
                        ox = topLeft.x + topLeft.width;
                        oy = topLeft.y + topLeft.height;
                        if (Shadow9PatchFactory.getDistance(cx, cy, ox, oy) <= radius) {
                            Shadow9PatchFactory.setRGB(data, cx, cy, color, alpha);
                        }
                    } else if (SWTExtensions.INSTANCE.contains(topRight, cx, cy)) {
                        ox = topRight.x;
                        oy = topRight.y + topRight.height;
                        if (Shadow9PatchFactory.getDistance(cx, cy, ox, oy) <= radius) {
                            Shadow9PatchFactory.setRGB(data, cx, cy, color, alpha);
                        }
                    } else if (SWTExtensions.INSTANCE.contains(bottomLeft, cx, cy)) {
                        ox = bottomLeft.x + bottomLeft.width;
                        oy = bottomLeft.y;
                        if (Shadow9PatchFactory.getDistance(cx, cy, ox, oy) <= radius) {
                            Shadow9PatchFactory.setRGB(data, cx, cy, color, alpha);
                        }
                    } else if (SWTExtensions.INSTANCE.contains(bottomRight, cx, cy)) {
                        ox = bottomRight.x;
                        oy = bottomRight.y;
                        if (Shadow9PatchFactory.getDistance(cx, cy, ox, oy) <= radius) {
                            Shadow9PatchFactory.setRGB(data, cx, cy, color, alpha);
                        }
                    } else {
                        Shadow9PatchFactory.setRGB(data, cx, cy, color, alpha);
                    }
                    ++cy;
                }
                ++cx;
            }
        } else {
            int cx = x;
            while (cx < x + w) {
                int cy = y;
                while (cy < y + h) {
                    Shadow9PatchFactory.setRGB(data, cx, cy, color, alpha);
                    ++cy;
                }
                ++cx;
            }
        }
    }

    private static ImageData generateShadowImageData(int width, int height, Rectangle rectangle, int cornerRadius, RGB shadowColor, int shadowRadius) {
        ImageData result = new ImageData(width, height, 32, new PaletteData(0xFF0000, 65280, 255));
        Shadow9PatchFactory.fill(result, 0, 0, width, height, shadowColor, 0, 0);
        Shadow9PatchFactory.fill(result, rectangle.x, rectangle.y, rectangle.width, rectangle.height, shadowColor, cornerRadius, 255);
        int i = 0;
        while (i < shadowRadius) {
            result = Shadow9PatchFactory.blur(result, shadowRadius);
            ++i;
        }
        return result;
    }

    private static int getAlpha(ImageData data, int x, int y) {
        x = Math.min(Math.max(0, x), data.width - 1);
        y = Math.min(Math.max(0, y), data.height - 1);
        return data.getAlpha(x, y);
    }

    private static int getDistance(int x1, int y1, int x2, int y2) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        return (int)Math.sqrt(dx * dx + dy * dy);
    }

    private static int limit(double v) {
        return (int)Math.min(Math.max(v, 0.0), 255.0);
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        final NinePatch patch = Shadow9PatchFactory.createShadowPatch(new RGB(255, 0, 0), 40, 40);
        Shell shell = new Shell(display);
        shell.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                patch.fill(event.gc, new Rectangle(200, 0, 300, 300));
                event.gc.drawRectangle(new Rectangle(200, 0, 300, 300));
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private static void setRGB(ImageData data, int x, int y, RGB rgb, int alpha) {
        data.setPixel(x, y, data.palette.getPixel(rgb));
        data.setAlpha(x, y, alpha);
    }
}

