/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.rendering.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.jeeeyul.eclipse.themes.rendering.JTabSettings;
import net.jeeeyul.eclipse.themes.util.HackedField;
import net.jeeeyul.eclipse.themes.util.HackedMethod0;
import net.jeeeyul.swtend.SWTExtensions;
import net.jeeeyul.swtend.ui.HSB;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class JTabRendererHelper {
    private static final String DATA_KEY__LAST_KNOWN_STATE = "_lastKnownState";

    public boolean getShowUnselectedClose(CTabFolder me) {
        return _CTabFolder.showUnselectedClose.get(me);
    }

    public int getFirstVisibleIndex(CTabFolder me) {
        return _CTabFolder.firstIndex.get(me);
    }

    public boolean getOnTop(CTabFolder folder) {
        return !this.getOnBottom(folder);
    }

    public Color getSelectedOuterColor(CTabFolderRenderer me) {
        return _CTabFolderRender.selectedOuterColor.get(me);
    }

    public Color[] getSelectionGradientColor(CTabFolder me) {
        return _CTabFolder.selectionGradientColors.get(me);
    }

    public int[] getSelectionGradientPercents(CTabFolder me) {
        return _CTabFolder.selectionGradientPercents.get(me);
    }

    public Color[] getGradientColor(CTabFolder me) {
        return _CTabFolder.gradientColors.get(me);
    }

    public int[] getGradientPercents(CTabFolder me) {
        return _CTabFolder.gradientPercents.get(me);
    }

    public boolean getOnBottom(CTabFolder me) {
        return (me.getStyle() & 0x400) != 0;
    }

    public ToolBar getMinMaxToolbar(CTabFolder me) {
        return _CTabFolder.minMaxTb.get(me);
    }

    public ToolBar getChevron(CTabFolder me) {
        return _CTabFolder.getChevron.invoke(me);
    }

    public ToolItem getChevronItem(CTabFolder me) {
        return _CTabFolder.chevronItem.get(me);
    }

    public Image getChevronImage(CTabFolder me) {
        return _CTabFolder.chevronImage.get(me);
    }

    public int getCloseImageState(CTabItem me) {
        return _CTabItem.closeImageState.get(me);
    }

    public Rectangle getCloseRect(CTabItem me) {
        return _CTabItem.closeRect.get(me);
    }

    public String getShortenText(CTabItem me) {
        return _CTabItem.shortenedText.get(me);
    }

    public int getShortenTextWidth(CTabItem me) {
        return _CTabItem.shortenedTextWidth.get(me);
    }

    public boolean getShowClose(CTabFolder folder) {
        return (folder.getStyle() & 0x40) != 0;
    }

    public boolean isCheveronVisible(CTabFolder me) {
        return _CTabFolder.chevronVisible.get(me);
    }

    public boolean isShowing(CTabItem me) {
        return _CTabItem.showing.get(me);
    }

    public Rectangle setCloseRect(CTabItem me, Rectangle rect) {
        return _CTabItem.closeRect.set(me, rect);
    }

    public CTabItem getLastVisibleItem(CTabFolder me) {
        ArrayList<CTabItem> visibles = new ArrayList<CTabItem>();
        CTabItem[] cTabItemArray = me.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem each = cTabItemArray[n2];
            if (each.isShowing()) {
                visibles.add(each);
            }
            ++n2;
        }
        if (visibles.size() == 0) {
            return null;
        }
        Collections.sort(visibles, new Comparator<CTabItem>(){

            @Override
            public int compare(CTabItem o1, CTabItem o2) {
                return o1.getBounds().x - o2.getBounds().x;
            }
        });
        return (CTabItem)visibles.get(visibles.size() - 1);
    }

    public CTabItem getFirstVisibleItem(CTabFolder me) {
        ArrayList<CTabItem> visibles = new ArrayList<CTabItem>();
        CTabItem[] cTabItemArray = me.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem each = cTabItemArray[n2];
            if (each.isShowing()) {
                visibles.add(each);
            }
            ++n2;
        }
        if (visibles.size() == 0) {
            return null;
        }
        Collections.sort(visibles, new Comparator<CTabItem>(){

            @Override
            public int compare(CTabItem o1, CTabItem o2) {
                return o1.getBounds().x - o2.getBounds().x;
            }
        });
        return (CTabItem)visibles.get(0);
    }

    public boolean isLastVisibleItem(CTabItem me) {
        return this.getLastVisibleItem(me.getParent()) == me;
    }

    public String setShortenText(CTabItem me, String shortenText) {
        return _CTabItem.shortenedText.set(me, shortenText);
    }

    public int setShortenTextWidth(CTabItem me, Integer width) {
        return _CTabItem.shortenedTextWidth.set(me, width);
    }

    public <T> T getFirstNotNull(Iterable<T> items) {
        for (T next : items) {
            if (next == null) continue;
            return next;
        }
        return null;
    }

    public GC fillGradientRectangle(GC gc, Rectangle bounds, HSB[] hsbs, int[] percents, boolean vertical) {
        Color[] colors = new Color[hsbs.length];
        int i = 0;
        while (i < hsbs.length) {
            colors[i] = SWTExtensions.INSTANCE.toAutoDisposeColor(hsbs[i]);
            ++i;
        }
        SWTExtensions.INSTANCE.fillGradientRectangle(gc, bounds, colors, percents, vertical);
        return gc;
    }

    public HSB getTextShadowColorFor(JTabSettings me, int state) {
        if ((state & 2) != 0) {
            return me.getSelectedTextShadowColor();
        }
        if ((state & 0x20) != 0) {
            return me.getHoverTextShadowColor();
        }
        return me.getUnselectedTextShadowColor();
    }

    public Point getTextShadowPositionFor(JTabSettings me, int state) {
        if ((state & 2) != 0) {
            return me.getSelectedTextShadowPosition();
        }
        if ((state & 0x20) != 0) {
            return me.getHoverTextShadowPosition();
        }
        return me.getUnselectedTextShadowPosition();
    }

    public HSB getTextColorFor(JTabSettings me, int state) {
        if ((state & 2) != 0) {
            return new HSB(me.getRenderer().getTabFolder().getSelectionForeground().getRGB());
        }
        if ((state & 0x20) != 0) {
            HSB hoverForgroundColor = me.getHoverForgroundColor();
            if (hoverForgroundColor == null) {
                return this.getTextColorFor(me, 0);
            }
            return hoverForgroundColor;
        }
        return new HSB(me.getRenderer().getTabFolder().getForeground().getRGB());
    }

    public HSB[] getBorderColorsFor(JTabSettings me, int state) {
        if ((state & 2) != 0) {
            return me.getSelectedBorderColors();
        }
        if ((state & 0x20) != 0) {
            return me.getHoverBorderColors();
        }
        return me.getUnselectedBorderColors();
    }

    public int[] getBorderPercentsFor(JTabSettings me, int state) {
        if ((state & 2) != 0) {
            return me.getSelectedBorderPercents();
        }
        if ((state & 0x20) != 0) {
            return me.getHoverBorderPercents();
        }
        return me.getUnselectedBorderPercents();
    }

    public HSB[] getItemFillFor(JTabSettings me, int state) {
        CTabFolder tabFolder = me.getRenderer().getTabFolder();
        if ((state & 2) != 0) {
            Color[] gradient = _CTabFolder.selectionGradientColors.get(tabFolder);
            if (gradient != null) {
                return SWTExtensions.INSTANCE.toHSBArray(gradient);
            }
            HSB hsb = new HSB(tabFolder.getSelectionBackground().getRGB());
            return new HSB[]{hsb, hsb};
        }
        if ((state & 0x20) != 0) {
            HSB[] gradient = me.getHoverBackgroundColors();
            if (gradient != null) {
                return gradient;
            }
            return this.getItemFillFor(me, 0);
        }
        return me.getUnselectedBackgroundColors();
    }

    public int[] getItemFillPercentsFor(JTabSettings me, int state) {
        CTabFolder tabFolder = me.getRenderer().getTabFolder();
        if ((state & 2) != 0) {
            int[] percents = _CTabFolder.selectionGradientPercents.get(tabFolder);
            if (percents != null) {
                return percents;
            }
            return new int[]{100};
        }
        if ((state & 0x20) != 0) {
            int[] percents = me.getHoverBackgroundPercents();
            if (percents != null) {
                return percents;
            }
            return this.getItemFillPercentsFor(me, 0);
        }
        return me.getUnselectedBackgroundPercents();
    }

    public Control[] getControls(CTabFolder me) {
        return _CTabFolder.controls.get(me);
    }

    public Image[] getControlBkImages(CTabFolder me) {
        return _CTabFolder.controlBkImages.get(me);
    }

    public boolean isWindow() {
        return this.getOSName().startsWith("Windows");
    }

    private String getOSName() {
        return System.getProperty("os.name");
    }

    public boolean isLinux() {
        return this.getOSName().startsWith("Linux");
    }

    public int lastKnownState(CTabItem item) {
        Integer state = (Integer)item.getData(DATA_KEY__LAST_KNOWN_STATE);
        if (state == null) {
            state = 0;
        }
        return state;
    }

    public int setLastKnownState(CTabItem item, int state) {
        item.setData(DATA_KEY__LAST_KNOWN_STATE, (Object)state);
        return state;
    }

    public int getState(CTabItem item) {
        return _CTabItem.state.get(item);
    }

    static interface _CTabFolder {
        public static final HackedField<CTabFolder, Boolean> onBottom = new HackedField(CTabFolder.class, "onBottom");
        public static final HackedMethod0<CTabFolder, ToolBar> getChevron = new HackedMethod0(CTabFolder.class, "getChevron");
        public static final HackedField<CTabFolder, Boolean> chevronVisible = new HackedField(CTabFolder.class, "chevronVisible");
        public static final HackedField<CTabFolder, Boolean> showUnselectedClose = new HackedField(CTabFolder.class, "showUnselectedClose");
        public static final HackedField<CTabFolder, ToolBar> minMaxTb = new HackedField(CTabFolder.class, "minMaxTb");
        public static final HackedField<CTabFolder, Color[]> gradientColors = new HackedField(CTabFolder.class, "gradientColors");
        public static final HackedField<CTabFolder, int[]> gradientPercents = new HackedField(CTabFolder.class, "gradientPercents");
        public static final HackedField<CTabFolder, Color[]> selectionGradientColors = new HackedField(CTabFolder.class, "selectionGradientColors");
        public static final HackedField<CTabFolder, int[]> selectionGradientPercents = new HackedField(CTabFolder.class, "selectionGradientPercents");
        public static final HackedField<CTabFolder, Integer> firstIndex = new HackedField(CTabFolder.class, "firstIndex");
        public static final HackedField<CTabFolder, Image> chevronImage = new HackedField(CTabFolder.class, "chevronImage");
        public static final HackedField<CTabFolder, ToolItem> chevronItem = new HackedField(CTabFolder.class, "chevronItem");
        public static final HackedField<CTabFolder, Control[]> controls = new HackedField(CTabFolder.class, "controls");
        public static final HackedField<CTabFolder, Image[]> controlBkImages = new HackedField(CTabFolder.class, "controlBkImages");
    }

    static interface _CTabFolderRender {
        public static final HackedField<CTabFolderRenderer, Color> selectedOuterColor = new HackedField(CTabFolderRenderer.class, "selectedOuterColor");
    }

    static interface _CTabItem {
        public static final HackedField<CTabItem, Boolean> showing = new HackedField(CTabItem.class, "showing");
        public static final HackedField<CTabItem, String> shortenedText = new HackedField(CTabItem.class, "shortenedText");
        public static final HackedField<CTabItem, Integer> shortenedTextWidth = new HackedField(CTabItem.class, "shortenedTextWidth");
        public static final HackedField<CTabItem, Rectangle> closeRect = new HackedField(CTabItem.class, "closeRect");
        public static final HackedField<CTabItem, Integer> closeImageState = new HackedField(CTabItem.class, "closeImageState");
        public static final HackedField<CTabItem, Integer> state = new HackedField(CTabItem.class, "state");
    }
}

