/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.rendering;

public enum VerticalAlignment {
    MIDDLE("Middle", "middle", 0),
    BASE_LINE("Baseline", "baseline", 1);

    private final String name;
    private final int value;
    private final String cssValue;
    private static VerticalAlignment[] VALUES;

    static {
        VALUES = new VerticalAlignment[]{MIDDLE, BASE_LINE};
    }

    private VerticalAlignment(String name, String cssValue, int value) {
        this.name = name;
        this.cssValue = cssValue;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String getCSSValue() {
        return this.cssValue;
    }

    public static VerticalAlignment fromValue(int value) {
        VerticalAlignment[] verticalAlignmentArray = VALUES;
        int n = VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            VerticalAlignment each = verticalAlignmentArray[n2];
            if (each.getValue() == value) {
                return each;
            }
            ++n2;
        }
        throw new IllegalArgumentException();
    }

    public static VerticalAlignment fromCSSValue(String css) {
        VerticalAlignment[] verticalAlignmentArray = VALUES;
        int n = VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            VerticalAlignment each = verticalAlignmentArray[n2];
            if (each.getCSSValue().equalsIgnoreCase(css)) {
                return each;
            }
            ++n2;
        }
        throw new IllegalArgumentException();
    }
}

