/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.rendering;

import com.google.common.base.Objects;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import net.jeeeyul.eclipse.themes.CoreImages;
import net.jeeeyul.eclipse.themes.css.internal.CSSClasses;
import net.jeeeyul.eclipse.themes.internal.Debug;
import net.jeeeyul.eclipse.themes.rendering.JTabSettings;
import net.jeeeyul.eclipse.themes.rendering.VerticalAlignment;
import net.jeeeyul.eclipse.themes.rendering.internal.JTabRendererHelper;
import net.jeeeyul.eclipse.themes.rendering.internal.Shadow9PatchFactory;
import net.jeeeyul.eclipse.themes.util.ImageDataUtil;
import net.jeeeyul.swtend.SWTExtensions;
import net.jeeeyul.swtend.sam.Procedure1;
import net.jeeeyul.swtend.ui.HSB;
import net.jeeeyul.swtend.ui.NinePatch;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class JeeeyulsTabRenderer
extends CTabFolderRenderer {
    @Extension
    private static JTabRendererHelper _jTabRendererHelper = new JTabRendererHelper();
    @Extension
    private static SWTExtensions _sWTExtensions = SWTExtensions.INSTANCE;
    private static final int CLOSE_BUTTON_WIDTH = 11;
    private static final int TEXT_FLAGS = _sWTExtensions.operator_or(1, 8);
    private static final int MINIMUM_SIZE = 0x1000000;
    private JTabSettings settings = new JTabSettings(this);
    private CTabFolder tabFolder;
    private NinePatch shadowNinePatch;
    private PropertyChangeListener settingsListener = it -> this.handleSettingChange(it);
    private Listener windowsRedrawHook = it -> this.parent.redraw();

    private void handleSettingChange(PropertyChangeEvent event) {
        block16: {
            String _propertyName = event.getPropertyName();
            if (_propertyName == null) break block16;
            switch (_propertyName) {
                case "shadow-radius": 
                case "border-radius": 
                case "shadow-color": {
                    _sWTExtensions.safeDispose((Resource)this.shadowNinePatch);
                    break;
                }
                case "border-colors": 
                case "margins": {
                    if (!Objects.equal((Object)event.getOldValue(), null) && !Objects.equal((Object)event.getNewValue(), null)) break;
                    this.tabFolder.getShell().layout(true, true);
                }
            }
        }
        this.tabFolder.redraw();
    }

    public JeeeyulsTabRenderer(CTabFolder parent) {
        super(parent);
        this.tabFolder = parent;
        this.settings.addPropertyChangeListener(this.settingsListener);
        boolean _isWindow = _jTabRendererHelper.isWindow();
        if (_isWindow) {
            this.tabFolder.addListener(11, this.windowsRedrawHook);
        }
    }

    protected void dispose() {
        _sWTExtensions.safeDispose((Resource)this.shadowNinePatch);
        this.settings.removePropertyChangeListener(this.settingsListener);
        if (_jTabRendererHelper.isWindow() && _sWTExtensions.isAlive((Widget)this.parent)) {
            this.parent.removeListener(11, this.windowsRedrawHook);
        }
        super.dispose();
    }

    protected Point computeSize(int part, int state, GC gc, int wHint, int hHint) {
        Point _switchResult = null;
        boolean _matched = false;
        if (part >= 0) {
            int _plus_5;
            int _plus_4;
            int _length;
            boolean _greaterThan;
            boolean _notEquals;
            _matched = true;
            CTabItem item = this.parent.getItem(part);
            int width = 0;
            int height = 0;
            width += this.settings.getTabItemPaddings().x;
            Image _image = item.getImage();
            boolean bl = _notEquals = !Objects.equal((Object)_image, null);
            if (_notEquals) {
                int _plus;
                width += item.getImage().getBounds().width;
                int _tabItemHorizontalSpacing = this.settings.getTabItemHorizontalSpacing();
                width = _plus = width + _tabItemHorizontalSpacing;
                height = item.getImage().getBounds().height;
            }
            String itemText = item.getText().trim();
            if (_sWTExtensions.hasFlags(state, new int[]{0x1000000}) && this.settings.isTruncateTabItems() && itemText.length() > this.settings.getMinimumCharacters()) {
                String _plus_1;
                String _substring = itemText.substring(0, this.settings.getMinimumCharacters());
                String _xifexpression = null;
                boolean _isUseEllipses = this.settings.isUseEllipses();
                _xifexpression = _isUseEllipses ? "..." : "";
                itemText = _plus_1 = String.valueOf(_substring) + _xifexpression;
            }
            boolean bl2 = _greaterThan = (_length = itemText.trim().length()) > 0;
            if (_greaterThan) {
                Font _font = item.getFont();
                Font _font_1 = this.parent.getFont();
                Point textSize = _sWTExtensions.computeTextExtent(itemText, (Font)_jTabRendererHelper.getFirstNotNull(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Font[]{_font, _font_1}))));
                width += textSize.x;
                height = Math.max(height, textSize.y);
            }
            if ((_jTabRendererHelper.getShowClose(this.parent) || item.getShowClose()) && (_sWTExtensions.hasFlags(state, new int[]{2}) || _jTabRendererHelper.getShowUnselectedClose(this.parent))) {
                int _plus_2;
                int _tabItemHorizontalSpacing_1 = this.settings.getTabItemHorizontalSpacing();
                width = _plus_2 = width + _tabItemHorizontalSpacing_1;
                width += 11;
            }
            int _tabHeight = this.parent.getTabHeight();
            int _plus_3 = _tabHeight + 2;
            height = Math.max(height, _plus_3);
            int _max = Math.max(this.settings.getTabItemPaddings().width, 0);
            width = _plus_4 = width + _max;
            int _tabSpacing = this.settings.getTabSpacing();
            width = _plus_5 = width + _tabSpacing;
            return new Point(width, height);
        }
        if (!_matched && Objects.equal((Object)part, (Object)-2)) {
            boolean _equals;
            _matched = true;
            int _tabHeight_1 = this.parent.getTabHeight();
            Point size = new Point(0, _tabHeight_1);
            int _itemCount = this.parent.getItemCount();
            boolean bl = _equals = _itemCount == 0;
            if (_equals) {
                size.y = Math.max(gc.textExtent((String)"Default").y, size.y);
            } else {
                int _itemCount_1 = this.parent.getItemCount();
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _itemCount_1, true);
                for (Integer i : _doubleDotLessThan) {
                    Point eachSize = this.computeSize(i, 0, gc, wHint, hHint);
                    size.y = Math.max(size.y, eachSize.y);
                }
            }
            int _minimumToolBarHeight = _sWTExtensions.getMinimumToolBarHeight();
            int _plus_6 = _minimumToolBarHeight + 2;
            size.y = Math.max(size.y, _plus_6);
            return size;
        }
        if (!_matched && Objects.equal((Object)part, (Object)-8)) {
            _matched = true;
            return new Point(11, this.computeSize((int)-2, (int)0, (GC)gc, (int)-1, (int)-1).y);
        }
        if (!_matched && Objects.equal((Object)part, (Object)-7)) {
            _matched = true;
            return new Point(20, 16);
        }
        if (!_matched) {
            _switchResult = super.computeSize(part, state, gc, wHint, hHint);
        }
        return _switchResult;
    }

    protected Rectangle computeTrim(int part, int state, int x, int y, int width, int height) {
        Rectangle result = new Rectangle(x, y, width, height);
        boolean _matched = false;
        if (Objects.equal((Object)part, (Object)-1)) {
            boolean _notEquals;
            int _plus_4;
            int _minus_2;
            _matched = true;
            result.x = result.x - this.settings.getMargins().x - this.settings.getPaddings().x;
            result.width = result.width + this.settings.getMargins().x + this.settings.getPaddings().x + this.settings.getPaddings().width + this.settings.getMargins().width;
            boolean _onBottom = _jTabRendererHelper.getOnBottom(this.tabFolder);
            if (_onBottom) {
                throw new UnsupportedOperationException();
            }
            int _tabHeight = this.tabFolder.getTabHeight();
            int _minus = result.y - _tabHeight;
            int _minus_1 = _minus - this.settings.getPaddings().y;
            result.y = _minus_2 = _minus_1 - 2;
            int _tabHeight_1 = this.tabFolder.getTabHeight();
            int _plus = result.height + _tabHeight_1;
            int _plus_1 = _plus + this.settings.getPaddings().y;
            int _plus_2 = _plus_1 + this.settings.getMargins().height;
            int _plus_3 = _plus_2 + this.settings.getPaddings().height;
            result.height = _plus_4 = _plus_3 + 2;
            HSB[] _borderColors = this.settings.getBorderColors();
            boolean bl = _notEquals = !Objects.equal((Object)_borderColors, null);
            if (_notEquals) {
                --result.x;
                result.width += 2;
                ++result.height;
            }
        }
        if (!_matched && Objects.equal((Object)part, (Object)-4)) {
            _matched = true;
            result.height += 10;
        }
        if (!_matched && Objects.equal((Object)part, (Object)-3)) {
            boolean _notEquals_1;
            int _plus_6;
            _matched = true;
            result.x = -this.settings.getMargins().x - 4;
            int _borderRadius = this.settings.getBorderRadius();
            double _divide = (double)_borderRadius / 1.8;
            double _plus_5 = _divide + 0.5;
            result.width = _plus_6 = this.settings.getMargins().x + this.settings.getMargins().width + (int)_plus_5;
            HSB[] _borderColors_1 = this.settings.getBorderColors();
            boolean bl = _notEquals_1 = !Objects.equal((Object)_borderColors_1, null);
            if (_notEquals_1) {
                int _width = result.width;
                result.width = _width + 2;
            }
        }
        if (!_matched && Objects.equal((Object)part, (Object)-2)) {
            _matched = true;
            result.x -= this.settings.getMargins().x;
            result.width = result.width + this.settings.getMargins().x + this.settings.getMargins().width;
        }
        if (!(_matched || part != -7 && part != -6 && part != -5)) {
            _matched = true;
        }
        if (!_matched && part >= 0) {
            int _plus_7;
            _matched = true;
            int _tabSpacing = this.settings.getTabSpacing();
            result.x = _plus_7 = this.settings.getTabItemPaddings().width + _tabSpacing;
        }
        if (!_matched) {
            result = super.computeTrim(part, state, x, y, width, height);
        }
        return result;
    }

    protected void draw(int part, int state, Rectangle bounds, GC gc) {
        try {
            Debug.countFrame();
            this.doDraw(part, state, bounds, gc);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private void doDraw(int part, int state, Rectangle bounds, GC gc) {
        gc.setAdvanced(true);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.setLineJoin(2);
        gc.setAlpha(255);
        gc.setFillRule(2);
        gc.setBackground(this.tabFolder.getBackground());
        gc.setForeground(this.tabFolder.getForeground());
        gc.setLineWidth(1);
        gc.setLineCap(3);
        gc.setLineStyle(1);
        boolean _matched = false;
        if (Objects.equal((Object)part, (Object)-2)) {
            _matched = true;
            this.drawTabHeader(part, state, bounds, gc);
            this.updateChevronImage();
            this.updateBkImages();
        }
        if (!_matched && Objects.equal((Object)part, (Object)-8)) {
            _matched = true;
            this.drawCloseButton(part, state, bounds, gc);
        }
        if (!_matched && Objects.equal((Object)part, (Object)-3)) {
            _matched = true;
        }
        if (!_matched && Objects.equal((Object)part, (Object)-1)) {
            _matched = true;
            this.drawTabBody(part, state, bounds, gc);
        }
        if (!_matched && Objects.equal((Object)part, (Object)-7)) {
            _matched = true;
            this.drawChevronButton(part, state, bounds, gc);
        }
        if (!_matched && part >= 0) {
            _matched = true;
            boolean _single = this.tabFolder.getSingle();
            if (_single) {
                return;
            }
            this.drawTabItem(part, state, bounds, gc);
        }
        if (!_matched) {
            super.draw(part, state, bounds, gc);
        }
    }

    protected Object drawChevronButton(int part, int state, Rectangle rectangle, GC gc) {
        return null;
    }

    private void updateBkImages() {
        String _oS = Platform.getOS();
        boolean _equals = Objects.equal((Object)_oS, (Object)"macosx");
        if (_equals) {
            boolean _notEquals;
            Control _topRight = this.tabFolder.getTopRight();
            boolean bl = _notEquals = !Objects.equal((Object)_topRight, null);
            if (_notEquals) {
                Control _topRight_1 = this.tabFolder.getTopRight();
                Procedures.Procedure1 _function = it -> it.setBackgroundImage(CoreImages.getImage("icons/transparent.gif"));
                ObjectExtensions.operator_doubleArrow((Object)_topRight_1, (Procedures.Procedure1)_function);
            }
        }
    }

    private void updateChevronImage() {
        Point chevronSize = _jTabRendererHelper.getChevron(this.parent).getSize();
        if (chevronSize.x == 0 || chevronSize.y == 0) {
            return;
        }
        Object _data = _jTabRendererHelper.getChevron(this.parent).getData("last-render-color");
        HSB lastColor = (HSB)_data;
        Object _data_1 = _jTabRendererHelper.getChevron(this.parent).getData("last-render-count");
        Integer lastCount = (Integer)_data_1;
        Functions.Function1 _function = it -> {
            boolean _isShowing = it.isShowing();
            return !_isShowing;
        };
        int count = Math.min(IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)this.parent.getItems())), (Functions.Function1)_function)), 99);
        if (Objects.equal((Object)lastColor, (Object)this.settings.getChevronColor()) && lastCount == count) {
            return;
        }
        Point size = this.computeSize(-7, 0, null, -1, -1);
        ToolBar _chevron = _jTabRendererHelper.getChevron(this.parent);
        _chevron.setBackgroundImage(null);
        Display _display = _sWTExtensions.getDisplay();
        Image mask = new Image((Device)_display, size.x, size.y);
        GC mgc = new GC((Drawable)mask);
        Procedure1 _function_1 = it -> {
            it.moveTo(0.0f, 0.0f);
            it.lineTo(3.0f, 3.0f);
            it.lineTo(0.0f, 6.0f);
            it.moveTo(3.0f, 0.0f);
            it.lineTo(6.0f, 3.0f);
            it.lineTo(3.0f, 6.0f);
        };
        Path path = _sWTExtensions.newTemporaryPath(_function_1);
        mgc.setBackground(_sWTExtensions.COLOR_BLACK());
        _sWTExtensions.fill(mgc, mask.getBounds());
        mgc.setForeground(_sWTExtensions.COLOR_WHITE());
        _sWTExtensions.draw(mgc, path);
        FontData fd = (FontData)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)this.parent.getFont().getFontData())));
        fd.setHeight(720 / JeeeyulsTabRenderer._sWTExtensions.getDisplay().getDPI().y);
        Display _display_1 = _sWTExtensions.getDisplay();
        mgc.setFont((Font)_sWTExtensions.autoDispose((Resource)new Font((Device)_display_1, fd)));
        mgc.drawString(Integer.valueOf(count).toString(), 6, 5, true);
        mgc.dispose();
        ImageData data = ImageDataUtil.convertBrightnessToAlpha(mask.getImageData(), this.settings.getChevronColor());
        mask.dispose();
        Display _display_2 = _sWTExtensions.getDisplay();
        Image itemImage = (Image)_sWTExtensions.shouldDisposeWith((Resource)new Image((Device)_display_2, data), (Widget)this.parent);
        Display _display_3 = _sWTExtensions.getDisplay();
        Image toolbarImg = (Image)_sWTExtensions.shouldDisposeWith((Resource)new Image((Device)_display_3, chevronSize.x, chevronSize.y), (Widget)this.parent);
        GC tgc = new GC((Drawable)toolbarImg);
        int _tabHeight = this.parent.getTabHeight();
        int _plus = _tabHeight + 3;
        Rectangle _rectangle = new Rectangle(0, -JeeeyulsTabRenderer._jTabRendererHelper.getChevron((CTabFolder)this.parent).getBounds().y, chevronSize.x, _plus);
        _sWTExtensions.fillGradientRectangle(tgc, _rectangle, _jTabRendererHelper.getGradientColor(this.parent), _jTabRendererHelper.getGradientPercents(this.parent), true);
        tgc.dispose();
        _sWTExtensions.safeDispose((Resource)_jTabRendererHelper.getChevron(this.parent).getBackgroundImage());
        ToolBar _chevron_1 = _jTabRendererHelper.getChevron(this.parent);
        _chevron_1.setBackgroundImage(null);
        ToolBar _chevron_2 = _jTabRendererHelper.getChevron(this.parent);
        _chevron_2.setBackgroundImage(toolbarImg);
        _sWTExtensions.safeDispose((Resource)_jTabRendererHelper.getChevronItem(this.parent).getImage());
        ToolItem _chevronItem = _jTabRendererHelper.getChevronItem(this.parent);
        _chevronItem.setImage(null);
        ToolItem _chevronItem_1 = _jTabRendererHelper.getChevronItem(this.parent);
        _chevronItem_1.setImage(itemImage);
        _jTabRendererHelper.getChevron(this.parent).setData("last-render-color", (Object)this.settings.getChevronColor());
        _jTabRendererHelper.getChevron(this.parent).setData("last-render-count", (Object)count);
    }

    private Rectangle getHeaderArea() {
        Rectangle _xifexpression = null;
        boolean _onTop = _jTabRendererHelper.getOnTop(this.tabFolder);
        if (_onTop) {
            int _tabHeight = this.tabFolder.getTabHeight();
            int _plus = _tabHeight + 2;
            _xifexpression = new Rectangle(this.settings.getMargins().x, 0, this.tabFolder.getSize().x - this.settings.getMargins().x - this.settings.getMargins().width, _plus);
        } else {
            Rectangle _rectangle = new Rectangle(0, this.tabFolder.getSize().y, this.tabFolder.getSize().x, this.tabFolder.getSize().y);
            Procedures.Procedure1 _function = it -> {
                _sWTExtensions.shrink(it, this.settings.getMargins().x, 0, this.settings.getMargins().width, 0);
                it.height = this.tabFolder.getTabHeight();
                int _tabHeight_1 = this.tabFolder.getTabHeight();
                int _minus = -_tabHeight_1;
                int _minus_1 = _minus - this.settings.getMargins().height;
                int _minus_2 = _minus_1 - 2;
                _sWTExtensions.translate(it, 0, _minus_2);
                _sWTExtensions.resize(it, 0, 2);
            };
            _xifexpression = (Rectangle)ObjectExtensions.operator_doubleArrow((Object)_rectangle, (Procedures.Procedure1)_function);
        }
        Rectangle headerArea = _xifexpression;
        return headerArea;
    }

    protected GC drawTabHeader(int part, int state, Rectangle bounds, GC gc) {
        boolean _equals;
        boolean _notEquals_2;
        Color[] _gradientColor;
        boolean _notEquals_1;
        boolean _notEquals;
        GC _xblockexpression = null;
        boolean _onBottom = _jTabRendererHelper.getOnBottom(this.parent);
        if (_onBottom) {
            throw new UnsupportedOperationException();
        }
        Rectangle fillArea = this.getHeaderArea();
        HSB[] _borderColors = this.settings.getBorderColors();
        boolean bl = _notEquals = !Objects.equal((Object)_borderColors, null);
        if (_notEquals) {
            _sWTExtensions.shrink(fillArea, 1, 0);
        }
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)(_gradientColor = _jTabRendererHelper.getGradientColor(this.tabFolder)), null);
        if (_notEquals_1) {
            int n = this.settings.getBorderRadius();
            _sWTExtensions.getClass();
            _sWTExtensions.fillGradientRoundRectangle(gc, fillArea, n, 3, _jTabRendererHelper.getGradientColor(this.tabFolder), _jTabRendererHelper.getGradientPercents(this.tabFolder), true);
        } else {
            gc.setBackground(this.tabFolder.getBackground());
            int n = this.settings.getBorderRadius();
            _sWTExtensions.getClass();
            _sWTExtensions.fillRoundRectangle(gc, fillArea, n, 3);
        }
        Rectangle outlineArea = _sWTExtensions.getResized(this.getHeaderArea(), -1, 0);
        HSB[] _borderColors_1 = this.settings.getBorderColors();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_borderColors_1, null);
        if (_notEquals_2) {
            gc.setForeground(_sWTExtensions.toAutoDisposeColor((HSB)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)this.settings.getBorderColors())))));
            Procedure1 _function = it -> {
                _sWTExtensions.moveTo(it, _sWTExtensions.getBottomLeft(outlineArea));
                _sWTExtensions.lineTo(it, _sWTExtensions.getTranslated(_sWTExtensions.getTopLeft(outlineArea), 0, this.settings.getBorderRadius()));
                int _borderRadius = this.settings.getBorderRadius();
                int _multiply = _borderRadius * 2;
                _sWTExtensions.addArc(it, _sWTExtensions.relocateTopLeftWith(_sWTExtensions.newRectangleWithSize(_multiply), outlineArea), 180, -90);
                Point _topRight = _sWTExtensions.getTopRight(outlineArea);
                int _borderRadius_1 = this.settings.getBorderRadius();
                int _minus = -_borderRadius_1;
                _sWTExtensions.lineTo(it, _sWTExtensions.getTranslated(_topRight, _minus, 0));
                int _borderRadius_2 = this.settings.getBorderRadius();
                int _multiply_1 = _borderRadius_2 * 2;
                _sWTExtensions.addArc(it, _sWTExtensions.relocateTopRightWith(_sWTExtensions.newRectangleWithSize(_multiply_1), outlineArea), 90, -90);
                _sWTExtensions.lineTo(it, _sWTExtensions.getBottomRight(outlineArea));
            };
            Path path = _sWTExtensions.newTemporaryPath(_function);
            _sWTExtensions.drawGradientPath(gc, path, _sWTExtensions.toAutoDisposeColors(this.settings.getBorderColors()), this.settings.getBorderPercents(), true);
        }
        GC _xifexpression = null;
        int _tabSpacing = this.settings.getTabSpacing();
        boolean bl4 = _equals = _tabSpacing == -1;
        if (_equals) {
            boolean _notEquals_3;
            GC _xblockexpression_1 = null;
            CTabItem lastItem = _jTabRendererHelper.getLastVisibleItem(this.parent);
            GC _xifexpression_1 = null;
            boolean bl5 = _notEquals_3 = !Objects.equal((Object)lastItem, null);
            if (_notEquals_3) {
                boolean _notEquals_5;
                boolean _notEquals_4;
                GC _xblockexpression_2 = null;
                Rectangle itemBounds = lastItem.getBounds();
                Procedure1 _function_1 = it -> {
                    _sWTExtensions.moveTo(it, _sWTExtensions.getTranslated(_sWTExtensions.getBottomRight(itemBounds), 0, -1));
                    _sWTExtensions.lineTo(it, _sWTExtensions.getTranslated(_sWTExtensions.getTopRight(itemBounds), 0, this.settings.getBorderRadius()));
                    int _borderRadius = this.settings.getBorderRadius();
                    int _multiply = _borderRadius * 2;
                    _sWTExtensions.addArc(it, _sWTExtensions.relocateTopRightWith(_sWTExtensions.newRectangleWithSize(_multiply), _sWTExtensions.getTopRight(itemBounds)), 0, 90);
                };
                Path path_1 = _sWTExtensions.newTemporaryPath(_function_1);
                HSB[] _itemFillFor = _jTabRendererHelper.getItemFillFor(this.settings, _jTabRendererHelper.getState(lastItem));
                boolean bl6 = _notEquals_4 = !Objects.equal((Object)_itemFillFor, null);
                if (_notEquals_4) {
                    _sWTExtensions.drawGradientPath(gc, path_1, _sWTExtensions.toAutoDisposeColors(_jTabRendererHelper.getItemFillFor(this.settings, _jTabRendererHelper.getState(lastItem))), _jTabRendererHelper.getItemFillPercentsFor(this.settings, _jTabRendererHelper.getState(lastItem)), true);
                }
                GC _xifexpression_2 = null;
                HSB[] _borderColorsFor = _jTabRendererHelper.getBorderColorsFor(this.settings, _jTabRendererHelper.getState(lastItem));
                boolean bl7 = _notEquals_5 = !Objects.equal((Object)_borderColorsFor, null);
                if (_notEquals_5) {
                    _xifexpression_2 = _sWTExtensions.drawGradientPath(gc, path_1, _sWTExtensions.toAutoDisposeColors(_jTabRendererHelper.getBorderColorsFor(this.settings, _jTabRendererHelper.getState(lastItem))), _jTabRendererHelper.getBorderPercentsFor(this.settings, _jTabRendererHelper.getState(lastItem)), true);
                }
                _xifexpression_1 = _xblockexpression_2 = _xifexpression_2;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected GC drawTabBody(int part, int state, Rectangle bounds, GC gc) {
        boolean _notEquals_1;
        boolean _greaterThan;
        boolean _notEquals;
        GC _xblockexpression = null;
        boolean _onBottom = _jTabRendererHelper.getOnBottom(this.parent);
        if (_onBottom) {
            throw new UnsupportedOperationException();
        }
        gc.setBackground(this.tabFolder.getParent().getBackground());
        _sWTExtensions.fill(gc, bounds);
        HSB _shadowColor = this.settings.getShadowColor();
        boolean bl = _notEquals = !Objects.equal((Object)_shadowColor, null);
        if (_notEquals) {
            this.drawShadow(part, state, bounds, gc);
        }
        Color _xifexpression = null;
        int _itemCount = this.parent.getItemCount();
        boolean bl2 = _greaterThan = _itemCount > 0;
        if (_greaterThan) {
            Color[] _selectionGradientColor = _jTabRendererHelper.getSelectionGradientColor(this.tabFolder);
            Color _last = null;
            if ((Iterable)Conversions.doWrapArray((Object)_selectionGradientColor) != null) {
                _last = (Color)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)_selectionGradientColor)));
            }
            Color _selectionBackground = this.tabFolder.getSelectionBackground();
            Functions.Function1 _function = it -> !Objects.equal((Object)it, null);
            _xifexpression = (Color)IterableExtensions.findFirst(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Color[]{_last, _selectionBackground})), (Functions.Function1)_function);
        } else {
            Color[] _gradientColor = _jTabRendererHelper.getGradientColor(this.tabFolder);
            Color _last_1 = null;
            if ((Iterable)Conversions.doWrapArray((Object)_gradientColor) != null) {
                _last_1 = (Color)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)_gradientColor)));
            }
            Color _background = this.tabFolder.getBackground();
            Functions.Function1 _function_1 = it -> !Objects.equal((Object)it, null);
            _xifexpression = (Color)IterableExtensions.findFirst(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Color[]{_last_1, _background})), (Functions.Function1)_function_1);
        }
        gc.setBackground(_xifexpression);
        Rectangle fillArea = this.tabArea();
        _sWTExtensions.setTop(fillArea, JeeeyulsTabRenderer._sWTExtensions.getBottom((Rectangle)this.getHeaderArea()).y);
        int n = this.settings.getBorderRadius();
        _sWTExtensions.getClass();
        _sWTExtensions.fillRoundRectangle(gc, fillArea, n, 12);
        _sWTExtensions.shrink(fillArea, this.settings.getPaddings());
        HSB[] _borderColors = this.settings.getBorderColors();
        boolean bl3 = _notEquals_1 = !Objects.equal((Object)_borderColors, null);
        if (_notEquals_1) {
            _sWTExtensions.shrink(fillArea, 1, 0, 1, 1);
        }
        gc.setBackground(this.parent.getBackground());
        _sWTExtensions.fill(gc, fillArea);
        GC _xifexpression_1 = null;
        if (this.settings.getBorderWidth() > 0 && !Objects.equal((Object)this.settings.getBorderColors(), null) && !Objects.equal((Object)this.settings.getBorderPercents(), null)) {
            GC _xblockexpression_1 = null;
            Rectangle offset = _sWTExtensions.getResized(this.tabArea(), -1, -1);
            gc.setLineWidth(this.settings.getBorderWidth());
            Procedure1 _function_2 = it -> {
                int _borderRadius = this.settings.getBorderRadius();
                int _multiply = _borderRadius * 2;
                Rectangle corner = _sWTExtensions.newRectangleWithSize(_multiply);
                _sWTExtensions.moveTo(it, _sWTExtensions.getBottomLeft(this.getHeaderArea()));
                _sWTExtensions.relocateBottomLeftWith(corner, offset);
                _sWTExtensions.lineTo(it, _sWTExtensions.getLeft(corner));
                _sWTExtensions.addArc(it, corner, 180, 90);
                _sWTExtensions.relocateBottomRightWith(corner, offset);
                _sWTExtensions.lineTo(it, _sWTExtensions.getBottom(corner));
                _sWTExtensions.addArc(it, corner, 270, 90);
                _sWTExtensions.lineTo(it, _sWTExtensions.getTranslated(_sWTExtensions.getBottomRight(this.getHeaderArea()), -1, 0));
            };
            Path bodyPath = _sWTExtensions.newTemporaryPath(_function_2);
            gc.setForeground(_sWTExtensions.toAutoDisposeColor((HSB)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)this.settings.getBorderColors())))));
            _sWTExtensions.draw(gc, bodyPath);
            _xifexpression_1 = _xblockexpression_1 = _sWTExtensions.draw(gc, bodyPath);
        }
        _xblockexpression = _xifexpression_1;
        return _xblockexpression;
    }

    protected GC drawCloseButton(int part, int state, Rectangle bounds, GC gc) {
        boolean _hasFlags_1;
        boolean _isDebuggingGUI;
        GC _xblockexpression = null;
        Rectangle box = _sWTExtensions.shrink(_sWTExtensions.relocateCenterWith(_sWTExtensions.newRectangleWithSize(bounds.width), bounds), 2);
        VerticalAlignment _closeButtonAlignment = this.settings.getCloseButtonAlignment();
        boolean _equals = Objects.equal((Object)((Object)_closeButtonAlignment), (Object)((Object)VerticalAlignment.BASE_LINE));
        if (_equals) {
            int _minus_1;
            int _height = gc.getFontMetrics().getHeight();
            int _minus = bounds.height - _height;
            int _divide = _minus / 2;
            int _leading = gc.getFontMetrics().getLeading();
            int _plus = _divide + _leading;
            int _ascent = gc.getFontMetrics().getAscent();
            int _plus_1 = _plus + _ascent;
            int _y = box.y = (_minus_1 = _plus_1 - box.height);
            int _switchResult = 0;
            int _closeButtonLineWidth = this.settings.getCloseButtonLineWidth();
            switch (_closeButtonLineWidth) {
                case 1: {
                    _switchResult = 1;
                    break;
                }
                case 2: {
                    _switchResult = 1;
                    break;
                }
                case 3: {
                    _switchResult = 0;
                    break;
                }
                default: {
                    _switchResult = 1;
                }
            }
            box.y = _y + _switchResult;
        }
        if (_isDebuggingGUI = Debug.isDebuggingGUI()) {
            gc.setBackground(_sWTExtensions.COLOR_MAGENTA());
            _sWTExtensions.fill(gc, box);
        }
        Procedure1 _function = it -> {
            _sWTExtensions.moveTo(it, _sWTExtensions.getTopLeft(box));
            _sWTExtensions.lineTo(it, _sWTExtensions.getBottomRight(box));
            _sWTExtensions.moveTo(it, _sWTExtensions.getTopRight(box));
            _sWTExtensions.lineTo(it, _sWTExtensions.getBottomLeft(box));
        };
        Path path = _sWTExtensions.newTemporaryPath(_function);
        HSB _switchResult_1 = null;
        boolean _matched = false;
        boolean _hasFlags = _sWTExtensions.hasFlags(state, new int[]{32});
        if (_hasFlags) {
            _matched = true;
            HSB _closeButtonHotColor = this.settings.getCloseButtonHotColor();
            HSB _closeButtonColor = this.settings.getCloseButtonColor();
            _switchResult_1 = (HSB)_jTabRendererHelper.getFirstNotNull(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new HSB[]{_closeButtonHotColor, _closeButtonColor, HSB.BLACK})));
        }
        if (!_matched && (_hasFlags_1 = _sWTExtensions.hasFlags(state, new int[]{2}))) {
            _matched = true;
            HSB _closeButtonActiveColor = this.settings.getCloseButtonActiveColor();
            HSB _closeButtonColor_1 = this.settings.getCloseButtonColor();
            _switchResult_1 = (HSB)_jTabRendererHelper.getFirstNotNull(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new HSB[]{_closeButtonActiveColor, _closeButtonColor_1, HSB.BLACK})));
        }
        if (!_matched) {
            HSB _closeButtonColor_2 = this.settings.getCloseButtonColor();
            _switchResult_1 = (HSB)_jTabRendererHelper.getFirstNotNull(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new HSB[]{_closeButtonColor_2, HSB.BLACK})));
        }
        HSB color = _switchResult_1;
        gc.setLineWidth(Math.max(this.settings.getCloseButtonLineWidth(), 1));
        gc.setForeground(_sWTExtensions.toAutoDisposeColor(color));
        _xblockexpression = _sWTExtensions.draw(gc, path);
        return _xblockexpression;
    }

    protected int drawTabItem(int part, int state, Rectangle bounds, GC gc) {
        HSB[] _borderColors;
        boolean _notEquals_6;
        boolean _equals_1;
        boolean _notEquals_3;
        boolean _notEquals_1;
        boolean _equals;
        int _xblockexpression = 0;
        CTabItem item = this.tabFolder.getItem(part);
        Rectangle _xifexpression = null;
        boolean _onBottom = _jTabRendererHelper.getOnBottom(this.tabFolder);
        if (_onBottom) {
            throw new UnsupportedOperationException();
        }
        Rectangle _bounds = item.getBounds();
        int _max = Math.max(this.settings.getTabSpacing(), 0);
        int _minus = -_max;
        Rectangle itemBounds = _xifexpression = _sWTExtensions.getResized(_bounds, _minus, 0);
        int _tabSpacing = this.settings.getTabSpacing();
        boolean bl = _equals = _tabSpacing == -1;
        if (_equals) {
            _sWTExtensions.resize(itemBounds, 1, 0);
        }
        this.drawTabItemBackground(part, state, itemBounds, gc);
        Rectangle _xifexpression_1 = null;
        Image _image = item.getImage();
        boolean _notEquals = !Objects.equal((Object)_image, null);
        _xifexpression_1 = _notEquals ? _sWTExtensions.translate(_sWTExtensions.relocateLeftWith(item.getImage().getBounds(), item.getBounds()), this.settings.getTabItemPaddings().x, 0) : new Rectangle(itemBounds.x + this.settings.getTabItemPaddings().x, 0, 0, itemBounds.height);
        Rectangle iconArea = _xifexpression_1;
        Image _image_1 = item.getImage();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_image_1, null);
        if (_notEquals_1) {
            boolean isBusy = CSSClasses.getStyleClasses((Widget)item).contains("busy");
            if (isBusy) {
                _sWTExtensions.drawImage(gc, item.getImage(), _sWTExtensions.getTopLeft(iconArea));
                Image watingIcon = CoreImages.getImage("icons/waiting.png");
                Point iconSize = _sWTExtensions.getSize(watingIcon.getBounds());
                _sWTExtensions.drawImage(gc, watingIcon, _sWTExtensions.getTranslated(_sWTExtensions.getTranslated(_sWTExtensions.getBottomRight(iconArea), _sWTExtensions.getNegated(iconSize)), 1, 1));
            } else {
                _sWTExtensions.drawImage(gc, item.getImage(), _sWTExtensions.getTopLeft(iconArea));
            }
        }
        Font _xifexpression_2 = null;
        Font _font = item.getFont();
        boolean _notEquals_2 = !Objects.equal((Object)_font, null);
        _xifexpression_2 = _notEquals_2 ? item.getFont() : this.tabFolder.getFont();
        gc.setFont(_xifexpression_2);
        boolean closeVisible = false;
        if ((_jTabRendererHelper.getShowClose(this.tabFolder) || item.getShowClose()) && JeeeyulsTabRenderer._jTabRendererHelper.getCloseRect((CTabItem)item).width > 0 && (_sWTExtensions.hasFlags(state, new int[]{2}) || _sWTExtensions.hasFlags(state, new int[]{32}))) {
            Procedure1 _function = it -> this.draw(-8, _jTabRendererHelper.getCloseImageState(item), _jTabRendererHelper.getCloseRect(item), gc);
            _sWTExtensions.withClip(gc, _jTabRendererHelper.getCloseRect(item), _function);
            closeVisible = true;
        }
        gc.setLineWidth(1);
        Point textSize = _sWTExtensions.computeTextExtent(item.getText(), gc.getFont());
        Rectangle textArea = _sWTExtensions.relocateLeftWith(_sWTExtensions.newRectangleWithSize(textSize), _sWTExtensions.getRight(iconArea));
        Image _image_2 = item.getImage();
        boolean bl3 = _notEquals_3 = !Objects.equal((Object)_image_2, null);
        if (_notEquals_3) {
            _sWTExtensions.translate(textArea, this.settings.getTabItemHorizontalSpacing(), 0);
        }
        if (closeVisible && !Objects.equal((Object)_jTabRendererHelper.getCloseRect(item), null) && JeeeyulsTabRenderer._jTabRendererHelper.getCloseRect((CTabItem)item).width > 0) {
            int _tabItemHorizontalSpacing = this.settings.getTabItemHorizontalSpacing();
            int _minus_1 = JeeeyulsTabRenderer._jTabRendererHelper.getCloseRect((CTabItem)item).x - _tabItemHorizontalSpacing;
            _sWTExtensions.setRight(textArea, _minus_1);
        } else {
            _sWTExtensions.setRight(textArea, JeeeyulsTabRenderer._sWTExtensions.getRight((Rectangle)itemBounds).x - this.settings.getTabItemPaddings().width);
        }
        boolean _isDebuggingGUI = Debug.isDebuggingGUI();
        if (_isDebuggingGUI) {
            gc.setForeground(_sWTExtensions.COLOR_MAGENTA());
            gc.setLineStyle(2);
            gc.setLineDash(new int[]{2, 2});
            gc.drawRectangle(textArea);
            gc.setLineStyle(1);
            gc.setLineWidth(1);
            gc.setForeground(_sWTExtensions.COLOR_RED());
            int _leading = gc.getFontMetrics().getLeading();
            int _plus = JeeeyulsTabRenderer._sWTExtensions.getTop((Rectangle)textArea).y + _leading;
            int _ascent = gc.getFontMetrics().getAscent();
            int _plus_1 = _plus + _ascent;
            int _leading_1 = gc.getFontMetrics().getLeading();
            int _plus_2 = JeeeyulsTabRenderer._sWTExtensions.getTop((Rectangle)textArea).y + _leading_1;
            int _ascent_1 = gc.getFontMetrics().getAscent();
            int _plus_3 = _plus_2 + _ascent_1;
            gc.drawLine(JeeeyulsTabRenderer._sWTExtensions.getLeft((Rectangle)textArea).x, _plus_1, JeeeyulsTabRenderer._sWTExtensions.getRight((Rectangle)textArea).x, _plus_3);
            gc.setForeground(_sWTExtensions.COLOR_BLUE());
            int _leading_2 = gc.getFontMetrics().getLeading();
            int _plus_4 = JeeeyulsTabRenderer._sWTExtensions.getTop((Rectangle)textArea).y + _leading_2;
            int _ascent_2 = gc.getFontMetrics().getAscent();
            int _plus_5 = _plus_4 + _ascent_2;
            int _descent = gc.getFontMetrics().getDescent();
            int _plus_6 = _plus_5 + _descent;
            int _leading_3 = gc.getFontMetrics().getLeading();
            int _plus_7 = JeeeyulsTabRenderer._sWTExtensions.getTop((Rectangle)textArea).y + _leading_3;
            int _ascent_3 = gc.getFontMetrics().getAscent();
            int _plus_8 = _plus_7 + _ascent_3;
            int _descent_1 = gc.getFontMetrics().getDescent();
            int _plus_9 = _plus_8 + _descent_1;
            gc.drawLine(JeeeyulsTabRenderer._sWTExtensions.getLeft((Rectangle)textArea).x, _plus_6, JeeeyulsTabRenderer._sWTExtensions.getRight((Rectangle)textArea).x, _plus_9);
        }
        String _xifexpression_3 = null;
        _xifexpression_3 = textSize.x > textArea.width ? this.shortenText(gc, item.getText(), textArea.width) : item.getText();
        String text = _xifexpression_3;
        if (this.parent.isFocusControl() && _sWTExtensions.hasFlags(state, new int[]{2})) {
            gc.setAlpha(90);
            gc.setForeground(_sWTExtensions.toAutoDisposeColor(_jTabRendererHelper.getTextColorFor(this.settings, state)));
            Point _topLeft = _sWTExtensions.getTopLeft(textArea);
            int _ascent_4 = gc.getFontMetrics().getAscent();
            int _plus_10 = _ascent_4 + 1;
            Point lineFrom = _sWTExtensions.getTranslated(_topLeft, 0, _plus_10);
            Point lineTo = _sWTExtensions.getTranslated(lineFrom, gc.textExtent((String)text.trim(), (int)JeeeyulsTabRenderer.TEXT_FLAGS).x, 0);
            _sWTExtensions.draw(gc, new Point[]{lineFrom, lineTo});
            gc.setAlpha(255);
        }
        HSB textShadowColor = _jTabRendererHelper.getTextShadowColorFor(this.settings, state);
        Point textShadowPosition = _jTabRendererHelper.getTextShadowPositionFor(this.settings, state);
        if (!(Objects.equal((Object)textShadowColor, null) || Objects.equal((Object)textShadowPosition, null) || _sWTExtensions.isEmpty(textShadowPosition))) {
            Point shadowPosition = _jTabRendererHelper.getTextShadowPositionFor(this.settings, state);
            gc.setForeground(_sWTExtensions.toAutoDisposeColor(_jTabRendererHelper.getTextShadowColorFor(this.settings, state)));
            Point delta = _sWTExtensions.getTranslated(_sWTExtensions.getTopLeft(textArea), shadowPosition);
            gc.drawText(text, delta.x, delta.y, TEXT_FLAGS);
        }
        gc.setForeground(_sWTExtensions.toAutoDisposeColor(_jTabRendererHelper.getTextColorFor(this.settings, state)));
        gc.drawText(text, textArea.x, textArea.y, TEXT_FLAGS);
        this.drawTabItemBorder(part, state, itemBounds, gc);
        int _tabSpacing_1 = this.settings.getTabSpacing();
        boolean bl4 = _equals_1 = _tabSpacing_1 == -1;
        if (_equals_1) {
            boolean hasToFix;
            boolean hasToDrawLeftBorder;
            CTabItem _xifexpression_4 = null;
            _xifexpression_4 = part > 0 ? this.parent.getItem(part - 1) : null;
            CTabItem prevItem = _xifexpression_4;
            boolean bl5 = hasToDrawLeftBorder = !_sWTExtensions.hasFlags(state, new int[]{2}) && !Objects.equal((Object)prevItem, null) && !_sWTExtensions.hasFlags(_jTabRendererHelper.getState(prevItem), new int[]{2}) && _sWTExtensions.hasFlags(_jTabRendererHelper.getState(prevItem), new int[]{32});
            if (hasToDrawLeftBorder) {
                HSB[] _hoverBorderColors;
                boolean _notEquals_5;
                boolean _notEquals_4;
                Procedure1 _function_1 = it -> {
                    _sWTExtensions.moveTo(it, _sWTExtensions.getBottomLeft(itemBounds));
                    _sWTExtensions.lineTo(it, _sWTExtensions.getTranslated(_sWTExtensions.getTopLeft(itemBounds), 0, this.settings.getBorderRadius()));
                    int _borderRadius = this.settings.getBorderRadius();
                    int _multiply = _borderRadius * 2;
                    _sWTExtensions.addArc(it, _sWTExtensions.relocateTopRightWith(_sWTExtensions.newRectangleWithSize(_multiply), _sWTExtensions.getTopLeft(itemBounds)), 0, 90);
                };
                Path path = _sWTExtensions.newTemporaryPath(_function_1);
                HSB[] _hoverBackgroundColors = this.settings.getHoverBackgroundColors();
                boolean bl6 = _notEquals_4 = !Objects.equal((Object)_hoverBackgroundColors, null);
                if (_notEquals_4) {
                    _sWTExtensions.drawGradientPath(gc, path, _sWTExtensions.toAutoDisposeColors(this.settings.getHoverBackgroundColors()), this.settings.getHoverBackgroundPercents(), true);
                }
                boolean bl7 = _notEquals_5 = !Objects.equal((Object)(_hoverBorderColors = this.settings.getHoverBorderColors()), null);
                if (_notEquals_5) {
                    _sWTExtensions.drawGradientPath(gc, path, _sWTExtensions.toAutoDisposeColors(_jTabRendererHelper.getBorderColorsFor(this.settings, 32)), _jTabRendererHelper.getBorderPercentsFor(this.settings, 32), true);
                }
            }
            boolean bl8 = hasToFix = !_sWTExtensions.hasFlags(state, new int[]{2}) && (_sWTExtensions.hasFlags(state, new int[]{32}) || _sWTExtensions.hasFlags(_jTabRendererHelper.lastKnownState(item), new int[]{32}));
            if (hasToFix) {
                this.parent.redraw(itemBounds.x + itemBounds.width - 1, itemBounds.y, 1, itemBounds.height, false);
                this.parent.update();
            }
        }
        boolean bl9 = _notEquals_6 = !Objects.equal((Object)(_borderColors = this.settings.getBorderColors()), null);
        if (_notEquals_6) {
            CTabItem _firstVisibleItem = _jTabRendererHelper.getFirstVisibleItem(this.parent);
            boolean _equals_2 = Objects.equal((Object)_firstVisibleItem, (Object)item);
            if (_equals_2) {
                Procedure1 _function_2 = it -> {
                    Point _topRight = _sWTExtensions.getTopRight(itemBounds);
                    int _max_1 = Math.max(this.settings.getTabSpacing(), 0);
                    int _plus_11 = _max_1 + 1;
                    _sWTExtensions.moveTo(it, _sWTExtensions.getTranslated(_topRight, _plus_11, 0));
                    _sWTExtensions.lineTo(it, _sWTExtensions.getTranslated(_sWTExtensions.getTopLeft(itemBounds), this.settings.getBorderRadius(), 0));
                    int _borderRadius = this.settings.getBorderRadius();
                    int _multiply = _borderRadius * 2;
                    int _borderRadius_1 = this.settings.getBorderRadius();
                    int _multiply_1 = _borderRadius_1 * 2;
                    _sWTExtensions.addArc(it, _sWTExtensions.newRectangle(rectangle.x, rectangle.y, _multiply, _multiply_1), 90, 90);
                    _sWTExtensions.lineTo(it, _sWTExtensions.getTranslated(_sWTExtensions.getBottomLeft(itemBounds), 0, 1));
                };
                Path path_1 = _sWTExtensions.newTemporaryPath(_function_2);
                _sWTExtensions.drawGradientPath(gc, path_1, _sWTExtensions.toAutoDisposeColors(this.settings.getBorderColors()), this.settings.getBorderPercents(), true);
            } else {
                gc.setForeground(_sWTExtensions.toAutoDisposeColor((HSB)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)this.settings.getBorderColors())))));
                Point _topRight = _sWTExtensions.getTopRight(itemBounds);
                int _max_1 = Math.max(this.settings.getTabSpacing(), 0);
                int _plus_11 = _max_1 + 1;
                _sWTExtensions.drawLine(gc, new Point[]{_sWTExtensions.getTranslated(_sWTExtensions.getTopLeft(itemBounds), -1, 0), _sWTExtensions.getTranslated(_topRight, _plus_11, 0)});
            }
        }
        _xblockexpression = _jTabRendererHelper.setLastKnownState(item, state);
        return _xblockexpression;
    }

    protected void drawTabItemBorder(int part, int state, Rectangle bounds, GC gc) {
        if (Objects.equal((Object)_jTabRendererHelper.getBorderColorsFor(this.settings, state), null) || Objects.equal((Object)_jTabRendererHelper.getBorderPercentsFor(this.settings, state), null)) {
            return;
        }
        Rectangle itemOutlineBounds = _sWTExtensions.getResized(bounds, -1, 0);
        CTabItem item = this.tabFolder.getItem(part);
        int _borderWidth = this.settings.getBorderWidth();
        int _divide = _borderWidth / 2;
        Rectangle outlineOffset = _sWTExtensions.shrink(itemOutlineBounds, _divide);
        Path outline = null;
        boolean _onBottom = _jTabRendererHelper.getOnBottom(this.tabFolder);
        if (_onBottom) {
            throw new UnsupportedOperationException();
        }
        Procedure1 _function = it -> {
            boolean _greaterThan;
            int keyLineY = JeeeyulsTabRenderer._sWTExtensions.getBottom((Rectangle)cTabItem.getBounds()).y - 1;
            int _borderRadius = this.settings.getBorderRadius();
            boolean bl = _greaterThan = _borderRadius > 0;
            if (_greaterThan) {
                Point _topLeft = _sWTExtensions.getTopLeft(outlineOffset);
                int _borderRadius_1 = this.settings.getBorderRadius();
                int _multiply = _borderRadius_1 * 2;
                int _borderRadius_2 = this.settings.getBorderRadius();
                int _multiply_1 = _borderRadius_2 * 2;
                Point _point = new Point(_multiply, _multiply_1);
                Rectangle corner = _sWTExtensions.newRectangle(_topLeft, _point);
                _sWTExtensions.relocateTopRightWith(corner, outlineOffset);
                boolean _hasFlags = _sWTExtensions.hasFlags(state, new int[]{2});
                if (_hasFlags) {
                    it.moveTo((float)(this.tabFolder.getSize().x - this.settings.getMargins().width - 1), (float)keyLineY);
                    it.lineTo((float)JeeeyulsTabRenderer._sWTExtensions.getBottomRight((Rectangle)rectangle2).x, (float)keyLineY);
                } else {
                    it.moveTo((float)JeeeyulsTabRenderer._sWTExtensions.getBottomRight((Rectangle)rectangle).x, (float)keyLineY);
                }
                _sWTExtensions.lineTo(it, _sWTExtensions.getRight(corner));
                _sWTExtensions.addArc(it, corner, 0, 90);
                _sWTExtensions.relocateTopLeftWith(corner, outlineOffset);
                _sWTExtensions.lineTo(it, _sWTExtensions.getTop(corner));
                if (Objects.equal((Object)this.settings.getBorderColors(), null) || !Objects.equal((Object)this.settings.getBorderColors(), null) && !Objects.equal((Object)item, (Object)_jTabRendererHelper.getFirstVisibleItem(this.parent))) {
                    _sWTExtensions.addArc(it, corner, 90, 90);
                    it.lineTo((float)rectangle.x, (float)keyLineY);
                    boolean _hasFlags_1 = _sWTExtensions.hasFlags(state, new int[]{2});
                    if (_hasFlags_1) {
                        boolean _notEquals;
                        Point left = new Point(this.settings.getMargins().x, keyLineY);
                        HSB[] _borderColors = this.settings.getBorderColors();
                        boolean bl2 = _notEquals = !Objects.equal((Object)_borderColors, null);
                        if (_notEquals) {
                            _sWTExtensions.translate(left, 1, 0);
                        }
                        _sWTExtensions.lineTo(it, left);
                    }
                }
            } else {
                boolean _hasFlags_2 = _sWTExtensions.hasFlags(state, new int[]{2});
                if (_hasFlags_2) {
                    int _borderWidth_1 = this.settings.getBorderWidth();
                    int _minus = this.tabFolder.getSize().x - this.settings.getMargins().width - _borderWidth_1;
                    it.moveTo((float)_minus, (float)keyLineY);
                    it.lineTo((float)JeeeyulsTabRenderer._sWTExtensions.getBottomRight((Rectangle)rectangle2).x, (float)keyLineY);
                } else {
                    it.moveTo((float)JeeeyulsTabRenderer._sWTExtensions.getBottomRight((Rectangle)rectangle).x, (float)keyLineY);
                }
                _sWTExtensions.lineTo(it, _sWTExtensions.getTopRight(itemOutlineBounds));
                _sWTExtensions.lineTo(it, _sWTExtensions.getTopLeft(itemOutlineBounds));
                if (Objects.equal((Object)this.settings.getBorderColors(), null) || !Objects.equal((Object)this.settings.getBorderColors(), null) && !Objects.equal((Object)item, (Object)_jTabRendererHelper.getFirstVisibleItem(this.parent))) {
                    it.lineTo((float)JeeeyulsTabRenderer._sWTExtensions.getBottomLeft((Rectangle)rectangle2).x, (float)keyLineY);
                    boolean _hasFlags_3 = _sWTExtensions.hasFlags(state, new int[]{2});
                    if (_hasFlags_3) {
                        boolean _notEquals_1;
                        Point left_1 = new Point(this.settings.getMargins().x, keyLineY);
                        HSB[] _borderColors_1 = this.settings.getBorderColors();
                        boolean bl3 = _notEquals_1 = !Objects.equal((Object)_borderColors_1, null);
                        if (_notEquals_1) {
                            _sWTExtensions.translate(left_1, this.settings.getBorderWidth(), 0);
                        }
                        _sWTExtensions.lineTo(it, left_1);
                    }
                }
            }
        };
        outline = _sWTExtensions.newTemporaryPath(_function);
        gc.setLineWidth(this.settings.getBorderWidth());
        _sWTExtensions.drawGradientPath(gc, outline, _sWTExtensions.toAutoDisposeColors(_jTabRendererHelper.getBorderColorsFor(this.settings, state)), _jTabRendererHelper.getBorderPercentsFor(this.settings, state), true);
    }

    protected GC drawTabItemBackground(int part, int state, Rectangle bounds, GC gc) {
        boolean _notEquals_1;
        boolean _notEquals;
        GC _xblockexpression = null;
        Rectangle itemBounds = _sWTExtensions.getCopy(bounds);
        HSB[] _borderColorsFor = _jTabRendererHelper.getBorderColorsFor(this.settings, state);
        boolean bl = _notEquals = !Objects.equal((Object)_borderColorsFor, null);
        if (_notEquals) {
            _sWTExtensions.shrink(itemBounds, 1, 0);
        }
        HSB[] colors = _jTabRendererHelper.getItemFillFor(this.settings, state);
        GC _xifexpression = null;
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)colors, null);
        if (_notEquals_1) {
            int n = this.settings.getBorderRadius();
            _sWTExtensions.getClass();
            _xifexpression = _sWTExtensions.fillGradientRoundRectangle(gc, itemBounds, n, 3, colors, _jTabRendererHelper.getItemFillPercentsFor(this.settings, state), true);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected GC drawShadow(int part, int state, Rectangle bounds, GC gc) {
        Procedure1 _function = it -> this.getShadow().fill(gc, _sWTExtensions.translate(_sWTExtensions.getExpanded(this.tabArea(), this.settings.getShadowRadius()), this.settings.getShadowPosition()));
        return _sWTExtensions.withClip(gc, bounds, _function);
    }

    protected Rectangle tabArea() {
        return _sWTExtensions.shrink(_sWTExtensions.setSize(_sWTExtensions.newRectangle(), this.tabFolder.getSize()), this.settings.getMargins().x, 0, this.settings.getMargins().width, this.settings.getMargins().height);
    }

    protected NinePatch getShadow() {
        if (Objects.equal((Object)this.shadowNinePatch, null) || this.shadowNinePatch.isDisposed()) {
            RGB _rGB = this.settings.getShadowColor().toRGB();
            int _borderRadius = this.settings.getBorderRadius();
            int _plus = _borderRadius + 3;
            this.shadowNinePatch = Shadow9PatchFactory.createShadowPatch(_rGB, _plus, this.settings.getShadowRadius());
        }
        return this.shadowNinePatch;
    }

    public JTabSettings getSettings() {
        return this.settings;
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    private String shortenText(GC gc, String text, int width) {
        String _xblockexpression = null;
        String _xifexpression = null;
        boolean _isUseEllipses = this.settings.isUseEllipses();
        _xifexpression = _isUseEllipses ? "..." : "";
        String ellipses = _xifexpression;
        _xblockexpression = _sWTExtensions.shortenText(gc, text, width, ellipses, TEXT_FLAGS);
        return _xblockexpression;
    }
}

