/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.internal;

import com.google.common.collect.EvictingQueue;
import java.util.Iterator;
import net.jeeeyul.swtend.SWTExtensions;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class FPSCounter {
    EvictingQueue<Long> queue = EvictingQueue.create((int)1000);
    private Label fpsLabel;
    private Shell shell;
    private Thread countThread;

    private Shell getShell() {
        if (this.shell == null || this.shell.isDisposed()) {
            this.create();
        }
        return this.shell;
    }

    public void addCount() {
        this.queue.add((Object)System.currentTimeMillis());
    }

    public long getFPS() {
        Iterator iter = this.queue.iterator();
        long offset = System.currentTimeMillis() - 1000L;
        long count = 0L;
        while (iter.hasNext()) {
            if ((Long)iter.next() <= offset) continue;
            ++count;
        }
        return count;
    }

    private void create() {
        if (this.shell != null && !this.shell.isDisposed()) {
            return;
        }
        Display display = Display.getDefault();
        this.shell = new Shell(display, 132);
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
        this.shell.setLayout((Layout)new GridLayout());
        this.fpsLabel = new Label((Composite)this.shell, 131072);
        Font font = new Font((Device)display, "sans-serif", 50, 0);
        SWTExtensions.INSTANCE.chainDispose((Widget)this.fpsLabel, new Resource[]{font});
        this.fpsLabel.setFont(font);
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 150;
        this.fpsLabel.setLayoutData((Object)layoutData);
        this.shell.pack();
        this.createAndStartCountThread();
    }

    private void createAndStartCountThread() {
        if (this.countThread != null) {
            return;
        }
        this.countThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!FPSCounter.this.shell.isDisposed()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (FPSCounter.this.fpsLabel != null && !FPSCounter.this.fpsLabel.isDisposed()) {
                                FPSCounter.this.fpsLabel.setText(Long.toString(FPSCounter.this.getFPS(), 10));
                            }
                        }
                    });
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.countThread.start();
    }

    public void open() {
        this.create();
        this.shell.open();
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        final FPSCounter counter = new FPSCounter();
        Shell shell = counter.getShell();
        counter.open();
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    counter.addCount();
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }).start();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

