/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.internal;

import java.text.MessageFormat;
import net.jeeeyul.eclipse.themes.internal.FPSCounter;
import org.eclipse.core.runtime.Platform;

public class Debug {
    private static Boolean DEBUG;
    private static Boolean DEBUG_GUI;
    private static Boolean USE_LOCAL_STORE;
    private static FPSCounter fpsCounter;

    public static FPSCounter getFpsCounter() {
        if (fpsCounter == null) {
            fpsCounter = new FPSCounter();
            fpsCounter.open();
        }
        return fpsCounter;
    }

    public static void println(Object o) {
        String msg;
        String string = msg = o != null ? o.toString() : "null";
        if (Debug.isDebugging()) {
            StackTraceElement element = Thread.currentThread().getStackTrace()[2];
            System.out.println(MessageFormat.format("({0}:{1, number,#}) : {2}", element.getFileName(), element.getLineNumber(), msg));
        }
    }

    public static boolean isDebugging() {
        if (DEBUG == null) {
            String debugOption = Platform.getDebugOption((String)MessageFormat.format("{0}/debug", "net.jeeeyul.eclipse.themes"));
            DEBUG = Boolean.parseBoolean(debugOption);
        }
        return DEBUG;
    }

    public static boolean isDebuggingGUI() {
        if (DEBUG_GUI == null) {
            String debugOption = Platform.getDebugOption((String)MessageFormat.format("{0}/debug/gui", "net.jeeeyul.eclipse.themes"));
            DEBUG_GUI = Boolean.parseBoolean(debugOption);
        }
        return DEBUG_GUI;
    }

    public static boolean useLocalStore() {
        if (USE_LOCAL_STORE == null) {
            String debugOption = Platform.getDebugOption((String)"net.jeeeyul.eclipse.themes/debug/useLocalStoreServer");
            USE_LOCAL_STORE = Boolean.parseBoolean(debugOption);
        }
        return USE_LOCAL_STORE;
    }

    public static void countFrame() {
        if (Debug.isDebuggingGUI()) {
            Debug.getFpsCounter().addCount();
        }
    }
}

