/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.css.internal.handlers;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.jeeeyul.eclipse.themes.css.internal.CSSCompabilityHelper;
import net.jeeeyul.eclipse.themes.internal.CSSExtension;
import net.jeeeyul.eclipse.themes.rendering.JTabSettings;
import net.jeeeyul.eclipse.themes.rendering.JeeeyulsTabRenderer;
import net.jeeeyul.eclipse.themes.rendering.VerticalAlignment;
import net.jeeeyul.eclipse.themes.rendering.internal.JTabRendererHelper;
import net.jeeeyul.swtend.ui.HSB;
import org.eclipse.e4.ui.css.core.dom.properties.Gradient;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.Measure;
import org.eclipse.e4.ui.css.swt.dom.CTabFolderElement;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTColorHelper;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class JTabCSSPropertyHandler
implements ICSSPropertyHandler {
    @Extension
    private CSSExtension _cSSExtension = new CSSExtension();

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, @Extension CSSEngine engine) throws Exception {
        boolean _switchResult;
        block224: {
            block222: {
                boolean _not;
                CTabFolderElement tabFolderElement = (CTabFolderElement)element;
                Object _nativeWidget = tabFolderElement.getNativeWidget();
                CTabFolder tabFolder = (CTabFolder)_nativeWidget;
                CTabFolderRenderer _renderer = tabFolder.getRenderer();
                boolean bl = _not = !(_renderer instanceof JeeeyulsTabRenderer);
                if (_not) {
                    return false;
                }
                CTabFolderRenderer _renderer_1 = tabFolder.getRenderer();
                JeeeyulsTabRenderer renderer = (JeeeyulsTabRenderer)_renderer_1;
                JTabSettings settings = renderer.getSettings();
                _switchResult = false;
                if (property == null) break block222;
                switch (property) {
                    case "jtab-selected-tab-background": {
                        boolean _xifexpression = false;
                        if (value instanceof CSSValueList) {
                            boolean _xblockexpression = false;
                            Gradient grad = CSSCompabilityHelper.getGradient((CSSValueList)value);
                            Color[] colors = CSSCompabilityHelper.getSWTColors(grad, tabFolder.getDisplay(), engine);
                            int[] percents = CSSCompabilityHelper.getPercents(grad);
                            tabFolder.setSelectionBackground(colors, percents, true);
                            _xifexpression = _xblockexpression = true;
                        } else {
                            boolean _xifexpression_1 = false;
                            if (value instanceof CSSPrimitiveValue) {
                                boolean _xblockexpression_1 = false;
                                Object _convert = engine.convert(value, Color.class, (Object)tabFolder.getDisplay());
                                Color newColor = (Color)_convert;
                                tabFolder.setSelectionBackground(new Color[]{newColor, newColor}, new int[]{100}, true);
                                _xifexpression_1 = _xblockexpression_1 = true;
                            } else {
                                _xifexpression_1 = false;
                            }
                            _xifexpression = _xifexpression_1;
                        }
                        _switchResult = _xifexpression;
                        break;
                    }
                    case "jtab-header-background": {
                        boolean _xifexpression_2 = false;
                        if (value instanceof CSSValueList) {
                            boolean _xblockexpression_2 = false;
                            Gradient grad = CSSCompabilityHelper.getGradient((CSSValueList)value);
                            Color[] colors = CSSCompabilityHelper.getSWTColors(grad, tabFolder.getDisplay(), engine);
                            int[] percents = CSSCompabilityHelper.getPercents(grad);
                            tabFolder.setBackground(colors, percents, true);
                            _xifexpression_2 = _xblockexpression_2 = true;
                        } else {
                            boolean _xifexpression_3 = false;
                            if (value instanceof CSSPrimitiveValue) {
                                boolean _xblockexpression_3 = false;
                                Object _convert = engine.convert(value, Color.class, (Object)tabFolder.getDisplay());
                                Color newColor = (Color)_convert;
                                tabFolder.setBackground(new Color[]{newColor, newColor}, new int[]{100}, true);
                                _xifexpression_3 = _xblockexpression_3 = true;
                            } else {
                                _xifexpression_3 = false;
                            }
                            _xifexpression_2 = _xifexpression_3;
                        }
                        _switchResult = _xifexpression_2;
                        break;
                    }
                    case "jtab-border-color": {
                        boolean _xifexpression_4 = false;
                        if (value instanceof CSSValueList) {
                            boolean _xblockexpression_4 = false;
                            Gradient grad = CSSCompabilityHelper.getGradient((CSSValueList)value);
                            settings.setBorderColors(this.toHSBArray(grad));
                            settings.setBorderPercents(CSSSWTColorHelper.getPercents((Gradient)grad));
                            _xifexpression_4 = _xblockexpression_4 = true;
                        } else {
                            boolean _xifexpression_5 = false;
                            if (value instanceof CSSPrimitiveValue) {
                                boolean _notEquals;
                                boolean _xblockexpression_5 = false;
                                RGB rgb = this._cSSExtension.toRGB(value);
                                boolean _xifexpression_6 = false;
                                boolean bl2 = _notEquals = !Objects.equal((Object)rgb, null);
                                if (_notEquals) {
                                    boolean _xblockexpression_6 = false;
                                    HSB hsb = new HSB(rgb);
                                    settings.setBorderColors(new HSB[]{hsb, hsb});
                                    settings.setBorderPercents(new int[]{100});
                                    _xifexpression_6 = _xblockexpression_6 = true;
                                } else {
                                    boolean _xifexpression_7 = false;
                                    String _cssText = ((CSSPrimitiveValue)value).getCssText();
                                    boolean _equals = Objects.equal((Object)_cssText, (Object)"none");
                                    if (_equals) {
                                        boolean _xblockexpression_7 = false;
                                        settings.setBorderColors(null);
                                        _xifexpression_7 = _xblockexpression_7 = true;
                                    } else {
                                        _xifexpression_7 = false;
                                    }
                                    _xifexpression_6 = _xifexpression_7;
                                }
                                _xifexpression_5 = _xblockexpression_5 = _xifexpression_6;
                            } else {
                                _xifexpression_5 = false;
                            }
                            _xifexpression_4 = _xifexpression_5;
                        }
                        _switchResult = _xifexpression_4;
                        break;
                    }
                    case "jtab-selected-border-color": {
                        boolean _xifexpression_6 = false;
                        if (value instanceof CSSValueList) {
                            boolean _xblockexpression_6 = false;
                            Gradient grad = CSSCompabilityHelper.getGradient((CSSValueList)value);
                            settings.setSelectedBorderColors(this.toHSBArray(grad));
                            settings.setSelectedBorderPercents(CSSSWTColorHelper.getPercents((Gradient)grad));
                            _xifexpression_6 = _xblockexpression_6 = true;
                        } else {
                            boolean _xifexpression_7 = false;
                            if (value instanceof CSSPrimitiveValue) {
                                boolean _notEquals;
                                boolean _xblockexpression_7 = false;
                                RGB rgb = this._cSSExtension.toRGB(value);
                                boolean _xifexpression_8 = false;
                                boolean bl3 = _notEquals = !Objects.equal((Object)rgb, null);
                                if (_notEquals) {
                                    boolean _xblockexpression_8 = false;
                                    HSB hsb = new HSB(rgb);
                                    settings.setSelectedBorderColors(new HSB[]{hsb, hsb});
                                    settings.setSelectedBorderPercents(new int[]{100});
                                    _xifexpression_8 = _xblockexpression_8 = true;
                                } else {
                                    boolean _xifexpression_9 = false;
                                    String _cssText = ((CSSPrimitiveValue)value).getCssText();
                                    boolean _equals = Objects.equal((Object)_cssText, (Object)"none");
                                    if (_equals) {
                                        boolean _xblockexpression_9 = false;
                                        settings.setSelectedBorderColors(null);
                                        _xifexpression_9 = _xblockexpression_9 = true;
                                    } else {
                                        _xifexpression_9 = false;
                                    }
                                    _xifexpression_8 = _xifexpression_9;
                                }
                                _xifexpression_7 = _xblockexpression_7 = _xifexpression_8;
                            } else {
                                _xifexpression_7 = false;
                            }
                            _xifexpression_6 = _xifexpression_7;
                        }
                        _switchResult = _xifexpression_6;
                        break;
                    }
                    case "jtab-unselected-border-color": {
                        boolean _xifexpression_8 = false;
                        if (value instanceof CSSValueList) {
                            boolean _xblockexpression_8 = false;
                            Gradient grad = CSSCompabilityHelper.getGradient((CSSValueList)value);
                            settings.setUnselectedBorderColors(this.toHSBArray(grad));
                            settings.setUnselectedBorderPercents(CSSSWTColorHelper.getPercents((Gradient)grad));
                            _xifexpression_8 = _xblockexpression_8 = true;
                        } else {
                            boolean _xifexpression_9 = false;
                            if (value instanceof CSSPrimitiveValue) {
                                boolean _notEquals;
                                boolean _xblockexpression_9 = false;
                                RGB rgb = this._cSSExtension.toRGB(value);
                                boolean _xifexpression_10 = false;
                                boolean bl4 = _notEquals = !Objects.equal((Object)rgb, null);
                                if (_notEquals) {
                                    boolean _xblockexpression_10 = false;
                                    HSB hsb = new HSB(rgb);
                                    settings.setUnselectedBorderColors(new HSB[]{hsb, hsb});
                                    settings.setUnselectedBorderPercents(new int[]{100});
                                    _xifexpression_10 = _xblockexpression_10 = true;
                                } else {
                                    boolean _xifexpression_11 = false;
                                    String _cssText = ((CSSPrimitiveValue)value).getCssText();
                                    boolean _equals = Objects.equal((Object)_cssText, (Object)"none");
                                    if (_equals) {
                                        boolean _xblockexpression_11 = false;
                                        settings.setUnselectedBorderColors(null);
                                        _xifexpression_11 = _xblockexpression_11 = true;
                                    } else {
                                        _xifexpression_11 = false;
                                    }
                                    _xifexpression_10 = _xifexpression_11;
                                }
                                _xifexpression_9 = _xblockexpression_9 = _xifexpression_10;
                            } else {
                                _xifexpression_9 = false;
                            }
                            _xifexpression_8 = _xifexpression_9;
                        }
                        _switchResult = _xifexpression_8;
                        break;
                    }
                    case "jtab-border-radius": {
                        boolean _xifexpression_10 = false;
                        if (value instanceof CSSPrimitiveValue) {
                            boolean _xblockexpression_10 = false;
                            float _floatValue = ((CSSPrimitiveValue)value).getFloatValue((short)5);
                            int radius = (int)_floatValue;
                            settings.setBorderRadius(radius);
                            _xifexpression_10 = _xblockexpression_10 = true;
                        } else {
                            _xifexpression_10 = false;
                        }
                        _switchResult = _xifexpression_10;
                        break;
                    }
                    case "jtab-spacing": {
                        boolean _xifexpression_11 = false;
                        if (value instanceof CSSPrimitiveValue) {
                            boolean _xblockexpression_11 = false;
                            float _floatValue = ((CSSPrimitiveValue)value).getFloatValue((short)5);
                            int tabSpacing = (int)_floatValue;
                            settings.setTabSpacing(tabSpacing);
                            _xifexpression_11 = _xblockexpression_11 = true;
                        } else {
                            _xifexpression_11 = false;
                        }
                        _switchResult = _xifexpression_11;
                        break;
                    }
                    case "jtab-close-button-color": {
                        boolean _notEquals;
                        boolean _xblockexpression_12 = false;
                        RGB rgb = this._cSSExtension.toRGB(value);
                        boolean bl5 = _notEquals = !Objects.equal((Object)rgb, null);
                        if (_notEquals) {
                            HSB hsb = new HSB(rgb.red, rgb.green, rgb.blue);
                            settings.setCloseButtonColor(hsb);
                        } else {
                            settings.setCloseButtonColor(null);
                        }
                        _switchResult = _xblockexpression_12 = true;
                        break;
                    }
                    case "jtab-close-button-line-width": {
                        boolean _xifexpression_12 = false;
                        if (value instanceof CSSPrimitiveValue) {
                            boolean _xblockexpression_13 = false;
                            float _floatValue = ((CSSPrimitiveValue)value).getFloatValue((short)5);
                            int lineWidth = (int)_floatValue;
                            settings.setCloseButtonLineWidth(lineWidth);
                            _xifexpression_12 = _xblockexpression_13 = true;
                        } else {
                            _xifexpression_12 = false;
                        }
                        _switchResult = _xifexpression_12;
                        break;
                    }
                    case "jtab-hover-color": {
                        boolean _notEquals;
                        boolean _xblockexpression_14 = false;
                        RGB rgb = this._cSSExtension.toRGB(value);
                        boolean bl6 = _notEquals = !Objects.equal((Object)rgb, null);
                        if (_notEquals) {
                            HSB hsb = new HSB(rgb.red, rgb.green, rgb.blue);
                            settings.setHoverForgroundColor(hsb);
                        } else {
                            settings.setHoverForgroundColor(null);
                        }
                        _switchResult = _xblockexpression_14 = true;
                        break;
                    }
                    case "jtab-hover-border-color": {
                        boolean _xifexpression_13 = false;
                        if (value instanceof CSSValueList) {
                            boolean _xblockexpression_15 = false;
                            Gradient grad = CSSCompabilityHelper.getGradient((CSSValueList)value);
                            settings.setHoverBorderColors(this.toHSBArray(grad));
                            settings.setHoverBorderPercents(CSSSWTColorHelper.getPercents((Gradient)grad));
                            _xifexpression_13 = _xblockexpression_15 = true;
                        } else {
                            boolean _xifexpression_14 = false;
                            if (value instanceof CSSPrimitiveValue) {
                                boolean _notEquals;
                                boolean _xblockexpression_16 = false;
                                RGB rgb = this._cSSExtension.toRGB(value);
                                boolean _xifexpression_15 = false;
                                boolean bl7 = _notEquals = !Objects.equal((Object)rgb, null);
                                if (_notEquals) {
                                    boolean _xblockexpression_17 = false;
                                    HSB hsb = new HSB(rgb);
                                    settings.setHoverBorderColors(new HSB[]{hsb, hsb});
                                    settings.setHoverBorderPercents(new int[]{100});
                                    _xifexpression_15 = _xblockexpression_17 = true;
                                } else {
                                    boolean _xifexpression_16 = false;
                                    String _cssText = ((CSSPrimitiveValue)value).getCssText();
                                    boolean _equals = Objects.equal((Object)_cssText, (Object)"none");
                                    if (_equals) {
                                        boolean _xblockexpression_18 = false;
                                        settings.setHoverBorderColors(null);
                                        _xifexpression_16 = _xblockexpression_18 = true;
                                    } else {
                                        _xifexpression_16 = false;
                                    }
                                    _xifexpression_15 = _xifexpression_16;
                                }
                                _xifexpression_14 = _xblockexpression_16 = _xifexpression_15;
                            } else {
                                _xifexpression_14 = false;
                            }
                            _xifexpression_13 = _xifexpression_14;
                        }
                        _switchResult = _xifexpression_13;
                        break;
                    }
                    case "jtab-close-button-hot-color": {
                        boolean _notEquals;
                        boolean _xblockexpression_17 = false;
                        RGB rgb = this._cSSExtension.toRGB(value);
                        boolean bl8 = _notEquals = !Objects.equal((Object)rgb, null);
                        if (_notEquals) {
                            HSB hsb = new HSB(rgb.red, rgb.green, rgb.blue);
                            settings.setCloseButtonHotColor(hsb);
                        } else {
                            settings.setCloseButtonHotColor(null);
                        }
                        _switchResult = _xblockexpression_17 = true;
                        break;
                    }
                    case "jtab-close-button-active-color": {
                        boolean _notEquals;
                        boolean _xblockexpression_18 = false;
                        RGB rgb = this._cSSExtension.toRGB(value);
                        boolean bl9 = _notEquals = !Objects.equal((Object)rgb, null);
                        if (_notEquals) {
                            HSB hsb = new HSB(rgb.red, rgb.green, rgb.blue);
                            settings.setCloseButtonActiveColor(hsb);
                        } else {
                            settings.setCloseButtonActiveColor(null);
                        }
                        _switchResult = _xblockexpression_18 = true;
                        break;
                    }
                    case "jtab-unselected-tabs-background": {
                        boolean _xifexpression_15 = false;
                        if (value instanceof CSSValueList) {
                            boolean _xblockexpression_19 = false;
                            Gradient grad = CSSCompabilityHelper.getGradient((CSSValueList)value);
                            settings.setUnselectedBackgroundColors(this.toHSBArray(grad));
                            settings.setUnselectedBackgroundPercents(CSSSWTColorHelper.getPercents((Gradient)grad));
                            _xifexpression_15 = _xblockexpression_19 = true;
                        } else {
                            boolean _xifexpression_16 = false;
                            if (value instanceof CSSPrimitiveValue) {
                                boolean _notEquals;
                                boolean _xblockexpression_20 = false;
                                RGB rgb = this._cSSExtension.toRGB(value);
                                boolean _xifexpression_17 = false;
                                boolean bl10 = _notEquals = !Objects.equal((Object)rgb, null);
                                if (_notEquals) {
                                    boolean _xblockexpression_21 = false;
                                    HSB hsb = new HSB(rgb);
                                    settings.setUnselectedBackgroundColors(new HSB[]{hsb, hsb});
                                    settings.setUnselectedBackgroundPercents(new int[]{100});
                                    _xifexpression_17 = _xblockexpression_21 = true;
                                } else {
                                    boolean _xifexpression_18 = false;
                                    String _cssText = ((CSSPrimitiveValue)value).getCssText();
                                    boolean _equals = Objects.equal((Object)_cssText, (Object)"none");
                                    if (_equals) {
                                        boolean _xblockexpression_22 = false;
                                        settings.setUnselectedBackgroundColors(null);
                                        _xifexpression_18 = _xblockexpression_22 = true;
                                    } else {
                                        _xifexpression_18 = false;
                                    }
                                    _xifexpression_17 = _xifexpression_18;
                                }
                                _xifexpression_16 = _xblockexpression_20 = _xifexpression_17;
                            } else {
                                _xifexpression_16 = false;
                            }
                            _xifexpression_15 = _xifexpression_16;
                        }
                        _switchResult = _xifexpression_15;
                        break;
                    }
                    case "jtab-hover-tabs-background": {
                        boolean _xifexpression_17 = false;
                        if (value instanceof CSSValueList) {
                            boolean _xblockexpression_21 = false;
                            Gradient grad = CSSCompabilityHelper.getGradient((CSSValueList)value);
                            settings.setHoverBackgroundColors(this.toHSBArray(grad));
                            settings.setHoverBackgroundPercents(CSSSWTColorHelper.getPercents((Gradient)grad));
                            _xifexpression_17 = _xblockexpression_21 = true;
                        } else {
                            boolean _xifexpression_18 = false;
                            if (value instanceof CSSPrimitiveValue) {
                                boolean _notEquals;
                                boolean _xblockexpression_22 = false;
                                RGB rgb = this._cSSExtension.toRGB(value);
                                boolean _xifexpression_19 = false;
                                boolean bl11 = _notEquals = !Objects.equal((Object)rgb, null);
                                if (_notEquals) {
                                    boolean _xblockexpression_23 = false;
                                    HSB hsb = new HSB(rgb);
                                    settings.setHoverBackgroundColors(new HSB[]{hsb, hsb});
                                    settings.setHoverBackgroundPercents(new int[]{100});
                                    _xifexpression_19 = _xblockexpression_23 = true;
                                } else {
                                    boolean _xifexpression_20 = false;
                                    String _cssText = ((CSSPrimitiveValue)value).getCssText();
                                    boolean _equals = Objects.equal((Object)_cssText, (Object)"none");
                                    if (_equals) {
                                        boolean _xblockexpression_24 = false;
                                        settings.setHoverBackgroundColors(null);
                                        _xifexpression_20 = _xblockexpression_24 = true;
                                    } else {
                                        _xifexpression_20 = false;
                                    }
                                    _xifexpression_19 = _xifexpression_20;
                                }
                                _xifexpression_18 = _xblockexpression_22 = _xifexpression_19;
                            } else {
                                _xifexpression_18 = false;
                            }
                            _xifexpression_17 = _xifexpression_18;
                        }
                        _switchResult = _xifexpression_17;
                        break;
                    }
                    case "jtab-margin": {
                        boolean _xifexpression_19 = false;
                        if (value instanceof CSSValueList) {
                            boolean _xblockexpression_23 = false;
                            Rectangle insets = this.toInset((CSSValueList)value);
                            settings.setMargins(insets);
                            _xifexpression_19 = _xblockexpression_23 = true;
                        } else {
                            boolean _xifexpression_20 = false;
                            if (value instanceof CSSPrimitiveValue) {
                                boolean _xblockexpression_24 = false;
                                float _floatValue = ((CSSPrimitiveValue)value).getFloatValue((short)5);
                                int margin = (int)_floatValue;
                                Rectangle _rectangle = new Rectangle(margin, margin, margin, margin);
                                settings.setMargins(_rectangle);
                                _xifexpression_20 = _xblockexpression_24 = true;
                            } else {
                                _xifexpression_20 = false;
                            }
                            _xifexpression_19 = _xifexpression_20;
                        }
                        _switchResult = _xifexpression_19;
                        break;
                    }
                    case "jtab-padding": {
                        boolean _xifexpression_21 = false;
                        if (value instanceof CSSValueList) {
                            boolean _xblockexpression_25 = false;
                            Rectangle insets = this.toInset((CSSValueList)value);
                            settings.setPaddings(insets);
                            _xifexpression_21 = _xblockexpression_25 = true;
                        } else {
                            boolean _xifexpression_22 = false;
                            if (value instanceof CSSPrimitiveValue) {
                                boolean _xblockexpression_26 = false;
                                float _floatValue = ((CSSPrimitiveValue)value).getFloatValue((short)5);
                                int margin = (int)_floatValue;
                                Rectangle _rectangle = new Rectangle(margin, margin, margin, margin);
                                settings.setPaddings(_rectangle);
                                _xifexpression_22 = _xblockexpression_26 = true;
                            } else {
                                _xifexpression_22 = false;
                            }
                            _xifexpression_21 = _xifexpression_22;
                        }
                        _switchResult = _xifexpression_21;
                        break;
                    }
                    case "jtab-shadow-color": {
                        boolean _notEquals;
                        boolean _xblockexpression_27 = false;
                        RGB rgb = this._cSSExtension.toRGB(value);
                        boolean bl12 = _notEquals = !Objects.equal((Object)rgb, null);
                        if (_notEquals) {
                            HSB hsb = new HSB(rgb.red, rgb.green, rgb.blue);
                            settings.setShadowColor(hsb);
                        } else {
                            settings.setShadowColor(null);
                        }
                        _switchResult = _xblockexpression_27 = true;
                        break;
                    }
                    case "jtab-shadow-position": {
                        boolean _xifexpression_23 = false;
                        if (value instanceof CSSValueList) {
                            boolean _xblockexpression_28 = false;
                            Point position = this.toPoint((CSSValueList)value);
                            settings.setShadowPosition(position);
                            _xifexpression_23 = _xblockexpression_28 = true;
                        } else {
                            boolean _xifexpression_24 = false;
                            if (value instanceof CSSPrimitiveValue) {
                                boolean _xblockexpression_29 = false;
                                float _floatValue = ((CSSPrimitiveValue)value).getFloatValue((short)5);
                                int v = (int)_floatValue;
                                Point _point = new Point(v, v);
                                settings.setShadowPosition(_point);
                                _xifexpression_24 = _xblockexpression_29 = true;
                            } else {
                                _xifexpression_24 = false;
                            }
                            _xifexpression_23 = _xifexpression_24;
                        }
                        _switchResult = _xifexpression_23;
                        break;
                    }
                    case "jtab-shadow-radius": {
                        boolean _xifexpression_25 = false;
                        if (value instanceof CSSPrimitiveValue) {
                            boolean _xblockexpression_30 = false;
                            float _floatValue = ((CSSPrimitiveValue)value).getFloatValue((short)5);
                            int v = (int)_floatValue;
                            settings.setShadowRadius(v);
                            _xifexpression_25 = _xblockexpression_30 = true;
                        } else {
                            _xifexpression_25 = false;
                        }
                        _switchResult = _xifexpression_25;
                        break;
                    }
                    case "jtab-selected-text-shadow-color": {
                        boolean _notEquals;
                        boolean _xblockexpression_31 = false;
                        RGB rgb = this._cSSExtension.toRGB(value);
                        boolean bl13 = _notEquals = !Objects.equal((Object)rgb, null);
                        if (_notEquals) {
                            HSB hsb = new HSB(rgb.red, rgb.green, rgb.blue);
                            settings.setSelectedTextShadowColor(hsb);
                        } else {
                            settings.setSelectedTextShadowColor(null);
                        }
                        _switchResult = _xblockexpression_31 = true;
                        break;
                    }
                    case "jtab-selected-text-shadow-position": {
                        boolean _xifexpression_26 = false;
                        if (value instanceof CSSValueList) {
                            boolean _xblockexpression_32 = false;
                            Point position = this.toPoint((CSSValueList)value);
                            settings.setSelectedTextShadowPosition(position);
                            _xifexpression_26 = _xblockexpression_32 = true;
                        } else {
                            boolean _xifexpression_27 = false;
                            if (value instanceof CSSPrimitiveValue) {
                                boolean _xblockexpression_33 = false;
                                float _floatValue = ((CSSPrimitiveValue)value).getFloatValue((short)5);
                                int v = (int)_floatValue;
                                Point _point = new Point(v, v);
                                settings.setSelectedTextShadowPosition(_point);
                                _xifexpression_27 = _xblockexpression_33 = true;
                            } else {
                                _xifexpression_27 = false;
                            }
                            _xifexpression_26 = _xifexpression_27;
                        }
                        _switchResult = _xifexpression_26;
                        break;
                    }
                    case "jtab-unselected-text-shadow-color": {
                        boolean _notEquals;
                        boolean _xblockexpression_34 = false;
                        RGB rgb = this._cSSExtension.toRGB(value);
                        boolean bl14 = _notEquals = !Objects.equal((Object)rgb, null);
                        if (_notEquals) {
                            HSB hsb = new HSB(rgb.red, rgb.green, rgb.blue);
                            settings.setUnselectedTextShadowColor(hsb);
                        } else {
                            settings.setUnselectedTextShadowColor(null);
                        }
                        _switchResult = _xblockexpression_34 = true;
                        break;
                    }
                    case "jtab-unselected-text-shadow-position": {
                        boolean _xifexpression_28 = false;
                        if (value instanceof CSSValueList) {
                            boolean _xblockexpression_35 = false;
                            Point position = this.toPoint((CSSValueList)value);
                            settings.setUnselectedTextShadowPosition(position);
                            _xifexpression_28 = _xblockexpression_35 = true;
                        } else {
                            boolean _xifexpression_29 = false;
                            if (value instanceof CSSPrimitiveValue) {
                                boolean _xblockexpression_36 = false;
                                float _floatValue = ((CSSPrimitiveValue)value).getFloatValue((short)5);
                                int v = (int)_floatValue;
                                Point _point = new Point(v, v);
                                settings.setUnselectedTextShadowPosition(_point);
                                _xifexpression_29 = _xblockexpression_36 = true;
                            } else {
                                _xifexpression_29 = false;
                            }
                            _xifexpression_28 = _xifexpression_29;
                        }
                        _switchResult = _xifexpression_28;
                        break;
                    }
                    case "jtab-hover-text-shadow-color": {
                        boolean _notEquals;
                        boolean _xblockexpression_37 = false;
                        RGB rgb = this._cSSExtension.toRGB(value);
                        boolean bl15 = _notEquals = !Objects.equal((Object)rgb, null);
                        if (_notEquals) {
                            HSB hsb = new HSB(rgb.red, rgb.green, rgb.blue);
                            settings.setHoverTextShadowColor(hsb);
                        } else {
                            settings.setHoverTextShadowColor(null);
                        }
                        _switchResult = _xblockexpression_37 = true;
                        break;
                    }
                    case "jtab-hover-text-shadow-position": {
                        boolean _xifexpression_30 = false;
                        if (value instanceof CSSValueList) {
                            boolean _xblockexpression_38 = false;
                            Point position = this.toPoint((CSSValueList)value);
                            settings.setHoverTextShadowPosition(position);
                            _xifexpression_30 = _xblockexpression_38 = true;
                        } else {
                            boolean _xifexpression_31 = false;
                            if (value instanceof CSSPrimitiveValue) {
                                boolean _xblockexpression_39 = false;
                                float _floatValue = ((CSSPrimitiveValue)value).getFloatValue((short)5);
                                int v = (int)_floatValue;
                                Point _point = new Point(v, v);
                                settings.setHoverTextShadowPosition(_point);
                                _xifexpression_31 = _xblockexpression_39 = true;
                            } else {
                                _xifexpression_31 = false;
                            }
                            _xifexpression_30 = _xifexpression_31;
                        }
                        _switchResult = _xifexpression_30;
                        break;
                    }
                    case "jtab-item-padding": {
                        boolean _xifexpression_32 = false;
                        if (value instanceof CSSValueList) {
                            boolean _xblockexpression_40 = false;
                            Rectangle insets = this.toInset((CSSValueList)value);
                            settings.setTabItemPaddings(insets);
                            _xifexpression_32 = _xblockexpression_40 = true;
                        } else {
                            boolean _xifexpression_33 = false;
                            if (value instanceof CSSPrimitiveValue) {
                                boolean _xblockexpression_41 = false;
                                float _floatValue = ((CSSPrimitiveValue)value).getFloatValue((short)5);
                                int margin = (int)_floatValue;
                                Rectangle _rectangle = new Rectangle(margin, margin, margin, margin);
                                settings.setTabItemPaddings(_rectangle);
                                _xifexpression_33 = _xblockexpression_41 = true;
                            } else {
                                _xifexpression_33 = false;
                            }
                            _xifexpression_32 = _xifexpression_33;
                        }
                        _switchResult = _xifexpression_32;
                        break;
                    }
                    case "jtab-item-horizontal-spacing": {
                        boolean _xifexpression_34 = false;
                        if (value instanceof CSSPrimitiveValue) {
                            boolean _xblockexpression_42 = false;
                            float _floatValue = ((CSSPrimitiveValue)value).getFloatValue((short)5);
                            int radius = (int)_floatValue;
                            settings.setTabItemHorizontalSpacing(radius);
                            _xifexpression_34 = _xblockexpression_42 = true;
                        } else {
                            _xifexpression_34 = false;
                        }
                        _switchResult = _xifexpression_34;
                        break;
                    }
                    case "jtab-chevron-color": {
                        boolean _notEquals;
                        boolean _xblockexpression_43 = false;
                        RGB rgb = this._cSSExtension.toRGB(value);
                        boolean bl16 = _notEquals = !Objects.equal((Object)rgb, null);
                        if (_notEquals) {
                            HSB hsb = new HSB(rgb.red, rgb.green, rgb.blue);
                            settings.setChevronColor(hsb);
                        } else {
                            settings.setChevronColor(null);
                        }
                        _switchResult = _xblockexpression_43 = true;
                        break;
                    }
                    case "jtab-truncate-tab-items": {
                        boolean _xblockexpression_44 = false;
                        Object _convert = engine.convert(value, Boolean.class, (Object)tabFolder.getDisplay());
                        Boolean truncateTabItems = (Boolean)_convert;
                        settings.setTruncateTabItems(truncateTabItems);
                        _switchResult = _xblockexpression_44 = true;
                        break;
                    }
                    case "jtab-use-ellipses": {
                        boolean _xblockexpression_45 = false;
                        Object _convert = engine.convert(value, Boolean.class, (Object)tabFolder.getDisplay());
                        Boolean useEllipse = (Boolean)_convert;
                        settings.setUseEllipses(useEllipse);
                        _switchResult = _xblockexpression_45 = true;
                        break;
                    }
                    case "jtab-minimum-characters": {
                        boolean _xifexpression_35 = false;
                        if (value instanceof CSSPrimitiveValue) {
                            boolean _xblockexpression_46 = false;
                            float _floatValue = ((CSSPrimitiveValue)value).getFloatValue((short)1);
                            int v = (int)_floatValue;
                            settings.setMinimumCharacters(v);
                            _xifexpression_35 = _xblockexpression_46 = true;
                        } else {
                            _xifexpression_35 = false;
                        }
                        _switchResult = _xifexpression_35;
                        break;
                    }
                    case "jtab-close-button-alignment": {
                        boolean _xblockexpression_47 = false;
                        if (value instanceof Measure) {
                            Measure measureValue = (Measure)value;
                            try {
                                VerticalAlignment alignment = VerticalAlignment.fromCSSValue(measureValue.getStringValue());
                                settings.setCloseButtonAlignment(alignment);
                            }
                            catch (Throwable _t) {
                                if (_t instanceof IllegalArgumentException) {
                                    return false;
                                }
                                throw Exceptions.sneakyThrow((Throwable)_t);
                            }
                        }
                        _switchResult = _xblockexpression_47 = false;
                        break;
                    }
                    default: {
                        _switchResult = false;
                        break;
                    }
                }
                break block224;
            }
            _switchResult = false;
        }
        boolean applied = _switchResult;
        return applied;
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        String _switchResult;
        block106: {
            block104: {
                boolean _not;
                JTabRendererHelper JTabRendererHelper2 = new JTabRendererHelper();
                CTabFolderElement tabFolderElement = (CTabFolderElement)element;
                Object _nativeWidget = tabFolderElement.getNativeWidget();
                CTabFolder tabFolder = (CTabFolder)_nativeWidget;
                CTabFolderRenderer _renderer = tabFolder.getRenderer();
                boolean bl = _not = !(_renderer instanceof JeeeyulsTabRenderer);
                if (_not) {
                    return null;
                }
                CTabFolderRenderer _renderer_1 = tabFolder.getRenderer();
                JeeeyulsTabRenderer renderer = (JeeeyulsTabRenderer)_renderer_1;
                JTabSettings settings = renderer.getSettings();
                _switchResult = null;
                if (property == null) break block104;
                switch (property) {
                    case "jtab-border-color": {
                        _switchResult = this.toHTML(settings.getBorderColors(), settings.getBorderPercents());
                        break;
                    }
                    case "jtab-selected-border-color": {
                        _switchResult = this.toHTML(settings.getSelectedBorderColors(), settings.getSelectedBorderPercents());
                        break;
                    }
                    case "jtab-unselected-border-color": {
                        _switchResult = this.toHTML(settings.getUnselectedBorderColors(), settings.getUnselectedBorderPercents());
                        break;
                    }
                    case "jtab-hover-border-color": {
                        _switchResult = this.toHTML(settings.getHoverBorderColors(), settings.getHoverBorderPercents());
                        break;
                    }
                    case "jtab-border-radius": {
                        StringConcatenation _builder = new StringConcatenation();
                        int _borderRadius = settings.getBorderRadius();
                        _builder.append((Object)_borderRadius);
                        _builder.append("px");
                        _switchResult = _builder.toString();
                        break;
                    }
                    case "jtab-spacing": {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        int _tabSpacing = settings.getTabSpacing();
                        _builder_1.append((Object)_tabSpacing);
                        _builder_1.append("px");
                        _switchResult = _builder_1.toString();
                        break;
                    }
                    case "jtab-close-button-color": {
                        _switchResult = this.safeHTML(settings.getCloseButtonColor());
                        break;
                    }
                    case "jtab-close-button-hot-color": {
                        _switchResult = this.safeHTML(settings.getCloseButtonHotColor());
                        break;
                    }
                    case "jtab-close-button-active-color": {
                        _switchResult = this.safeHTML(settings.getCloseButtonActiveColor());
                        break;
                    }
                    case "jtab-close-button-line-width": {
                        StringConcatenation _builder_2 = new StringConcatenation();
                        int _closeButtonLineWidth = settings.getCloseButtonLineWidth();
                        _builder_2.append((Object)_closeButtonLineWidth);
                        _builder_2.append("px");
                        _switchResult = _builder_2.toString();
                        break;
                    }
                    case "jtab-header-background": {
                        _switchResult = this.toHTML(JTabRendererHelper2.getGradientColor(tabFolder), JTabRendererHelper2.getGradientPercents(tabFolder));
                        break;
                    }
                    case "jtab-selected-tab-background": {
                        _switchResult = this.toHTML(JTabRendererHelper2.getSelectionGradientColor(tabFolder), JTabRendererHelper2.getSelectionGradientPercents(tabFolder));
                        break;
                    }
                    case "jtab-unselected-tabs-background": {
                        _switchResult = this.toHTML(settings.getUnselectedBackgroundColors(), settings.getUnselectedBackgroundPercents());
                        break;
                    }
                    case "jtab-hover-tabs-background": {
                        _switchResult = this.toHTML(settings.getHoverBackgroundColors(), settings.getHoverBackgroundPercents());
                        break;
                    }
                    case "jtab-hover-color": {
                        _switchResult = this.safeHTML(settings.getHoverForgroundColor());
                        break;
                    }
                    case "jtab-margin": {
                        StringConcatenation _builder_3 = new StringConcatenation();
                        _builder_3.append((Object)settings.getMargins().y);
                        _builder_3.append("px ");
                        _builder_3.append((Object)settings.getMargins().width);
                        _builder_3.append("px ");
                        _builder_3.append((Object)settings.getMargins().height);
                        _builder_3.append("px ");
                        _builder_3.append((Object)settings.getMargins().x);
                        _builder_3.append("px");
                        _switchResult = _builder_3.toString();
                        break;
                    }
                    case "jtab-padding": {
                        StringConcatenation _builder_4 = new StringConcatenation();
                        _builder_4.append((Object)settings.getPaddings().y);
                        _builder_4.append("px ");
                        _builder_4.append((Object)settings.getPaddings().width);
                        _builder_4.append("px ");
                        _builder_4.append((Object)settings.getPaddings().height);
                        _builder_4.append("px ");
                        _builder_4.append((Object)settings.getPaddings().x);
                        _builder_4.append("px");
                        _switchResult = _builder_4.toString();
                        break;
                    }
                    case "jtab-shadow-color": {
                        _switchResult = this.safeHTML(settings.getShadowColor());
                        break;
                    }
                    case "jtab-shadow-radius": {
                        StringConcatenation _builder_5 = new StringConcatenation();
                        int _shadowRadius = settings.getShadowRadius();
                        _builder_5.append((Object)_shadowRadius);
                        _builder_5.append("px");
                        _switchResult = _builder_5.toString();
                        break;
                    }
                    case "jtab-shadow-position": {
                        _switchResult = this.safeHTML(settings.getShadowPosition());
                        break;
                    }
                    case "jtab-selected-text-shadow-color": {
                        _switchResult = this.safeHTML(settings.getSelectedTextShadowColor());
                        break;
                    }
                    case "jtab-unselected-text-shadow-color": {
                        _switchResult = this.safeHTML(settings.getUnselectedTextShadowColor());
                        break;
                    }
                    case "jtab-hover-text-shadow-color": {
                        _switchResult = this.safeHTML(settings.getHoverTextShadowColor());
                        break;
                    }
                    case "jtab-selected-text-shadow-position": {
                        _switchResult = this.safeHTML(settings.getSelectedTextShadowPosition());
                        break;
                    }
                    case "jtab-unselected-text-shadow-position": {
                        _switchResult = this.safeHTML(settings.getUnselectedTextShadowPosition());
                        break;
                    }
                    case "jtab-hover-text-shadow-position": {
                        _switchResult = this.safeHTML(settings.getHoverTextShadowPosition());
                        break;
                    }
                    case "jtab-item-padding": {
                        StringConcatenation _builder_6 = new StringConcatenation();
                        _builder_6.append("0px ");
                        _builder_6.append((Object)settings.getTabItemPaddings().width);
                        _builder_6.append("px 0px ");
                        _builder_6.append((Object)settings.getTabItemPaddings().x);
                        _builder_6.append("px");
                        _switchResult = _builder_6.toString();
                        break;
                    }
                    case "jtab-item-horizontal-spacing": {
                        StringConcatenation _builder_7 = new StringConcatenation();
                        int _tabItemHorizontalSpacing = settings.getTabItemHorizontalSpacing();
                        _builder_7.append((Object)_tabItemHorizontalSpacing);
                        _builder_7.append("px");
                        _switchResult = _builder_7.toString();
                        break;
                    }
                    case "jtab-chevron-color": {
                        StringConcatenation _builder_8 = new StringConcatenation();
                        String _hTMLCode = settings.getChevronColor().toHTMLCode();
                        _builder_8.append(_hTMLCode);
                        _switchResult = _builder_8.toString();
                        break;
                    }
                    case "jtab-truncate-tab-items": {
                        StringConcatenation _builder_9 = new StringConcatenation();
                        boolean _isTruncateTabItems = settings.isTruncateTabItems();
                        _builder_9.append((Object)_isTruncateTabItems);
                        _switchResult = _builder_9.toString();
                        break;
                    }
                    case "jtab-use-ellipses": {
                        StringConcatenation _builder_10 = new StringConcatenation();
                        boolean _isUseEllipses = settings.isUseEllipses();
                        _builder_10.append((Object)_isUseEllipses);
                        _switchResult = _builder_10.toString();
                        break;
                    }
                    case "jtab-minimum-characters": {
                        StringConcatenation _builder_11 = new StringConcatenation();
                        int _minimumCharacters = settings.getMinimumCharacters();
                        _builder_11.append((Object)_minimumCharacters);
                        _switchResult = _builder_11.toString();
                        break;
                    }
                    case "jtab-close-button-alignment": {
                        _switchResult = settings.getCloseButtonAlignment().getCSSValue();
                        break;
                    }
                    default: {
                        _switchResult = null;
                        break;
                    }
                }
                break block106;
            }
            _switchResult = null;
        }
        return _switchResult;
    }

    private String safeHTML(HSB hsb) {
        String _xifexpression = null;
        boolean _equals = Objects.equal((Object)hsb, null);
        _xifexpression = _equals ? "none" : hsb.toHTMLCode();
        return _xifexpression;
    }

    private String safeHTML(Point point) {
        String _xifexpression = null;
        boolean _equals = Objects.equal((Object)point, null);
        if (_equals) {
            _xifexpression = "none";
        } else {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)point.x);
            _builder.append("px ");
            _builder.append((Object)point.y);
            _builder.append("px");
            _xifexpression = _builder.toString();
        }
        return _xifexpression;
    }

    private String toHTML(HSB[] colors, int[] percents) {
        if (Objects.equal((Object)colors, null) || Objects.equal((Object)percents, null)) {
            return "none";
        }
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> it.toHTMLCode();
        String _join = IterableExtensions.join((Iterable)((Iterable)Conversions.doWrapArray((Object)colors)), (CharSequence)" ", (Functions.Function1)_function);
        _builder.append(_join);
        _builder.append(" ");
        Functions.Function1 _function_1 = it -> it + "%";
        String _join_1 = IterableExtensions.join((Iterable)((Iterable)Conversions.doWrapArray((Object)percents)), (CharSequence)" ", (Functions.Function1)_function_1);
        _builder.append(_join_1);
        return _builder.toString();
    }

    private String toHTML(Color[] colors, int[] percents) {
        if (Objects.equal((Object)colors, null) || Objects.equal((Object)percents, null)) {
            return "none";
        }
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> {
            RGB _rGB = it.getRGB();
            return new HSB(_rGB).toHTMLCode();
        };
        String _join = IterableExtensions.join((Iterable)((Iterable)Conversions.doWrapArray((Object)colors)), (CharSequence)" ", (Functions.Function1)_function);
        _builder.append(_join);
        _builder.append(" ");
        Functions.Function1 _function_1 = it -> it + "%";
        String _join_1 = IterableExtensions.join((Iterable)((Iterable)Conversions.doWrapArray((Object)percents)), (CharSequence)" ", (Functions.Function1)_function_1);
        _builder.append(_join_1);
        return _builder.toString();
    }

    private Rectangle toInset(CSSValueList list) {
        int top = 0;
        int right = 0;
        int bottom = 0;
        int left = 0;
        int _length = list.getLength();
        switch (_length) {
            case 4: {
                top = this.asPX(list.item(0));
                right = this.asPX(list.item(1));
                bottom = this.asPX(list.item(2));
                left = this.asPX(list.item(3));
                break;
            }
            case 2: {
                top = this.asPX(list.item(0));
                right = this.asPX(list.item(1));
                bottom = this.asPX(list.item(0));
                left = this.asPX(list.item(1));
            }
        }
        return new Rectangle(left, top, right, bottom);
    }

    private Point toPoint(CSSValueList list) {
        int x = 0;
        int y = 0;
        int _length = list.getLength();
        switch (_length) {
            case 2: {
                x = this.asPX(list.item(0));
                y = this.asPX(list.item(1));
            }
        }
        return new Point(x, y);
    }

    private int asPX(CSSValue value) {
        if (value instanceof CSSPrimitiveValue) {
            float _floatValue = ((CSSPrimitiveValue)value).getFloatValue((short)5);
            return (int)_floatValue;
        }
        return 0;
    }

    private HSB[] toHSBArray(Gradient grad) {
        ArrayList hsb = CollectionLiterals.newArrayList((Object[])new HSB[0]);
        Consumer<Object> _function = it -> {
            HSB _hSB = new HSB((RGB)it);
            hsb.add(_hSB);
        };
        grad.getRGBs().forEach(_function);
        return (HSB[])Conversions.unwrapArray((Object)hsb, HSB.class);
    }
}

