/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.css.internal.handlers;

import com.google.common.base.Objects;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.jeeeyul.eclipse.themes.css.EditorLineSupport;
import net.jeeeyul.eclipse.themes.internal.CSSExtension;
import net.jeeeyul.swtend.ui.HSB;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.CompositeElement;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class JStyledTextPropertyHandler
implements ICSSPropertyHandler {
    @Extension
    private CSSExtension _cSSExtension = new CSSExtension();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        boolean _xblockexpression = false;
        CompositeElement compositeElement = (CompositeElement)element;
        Object _nativeWidget = compositeElement.getNativeWidget();
        Composite composite = (Composite)_nativeWidget;
        if (!(composite instanceof StyledText)) {
            return false;
        }
        StyledText styledText = (StyledText)composite;
        EditorLineSupport els = EditorLineSupport.get(styledText);
        boolean _switchResult = false;
        if (property == null) return false;
        switch (property) {
            case "jeditor-line-style": {
                boolean _xifexpression = false;
                if (!(value instanceof CSSPrimitiveValue)) return false;
                boolean _xblockexpression_1 = false;
                int _switchResult_1 = 0;
                String _cssText = ((CSSPrimitiveValue)value).getCssText();
                if (_cssText != null) {
                    switch (_cssText) {
                        case "solid": {
                            _switchResult_1 = 1;
                            break;
                        }
                        case "dashed": {
                            _switchResult_1 = 2;
                            break;
                        }
                        case "dotted": {
                            _switchResult_1 = 3;
                            break;
                        }
                        default: {
                            _switchResult_1 = 0;
                            break;
                        }
                    }
                } else {
                    _switchResult_1 = 0;
                }
                els.setLineStyle(_switchResult_1);
                _xifexpression = _xblockexpression_1 = true;
                _switchResult = _xifexpression;
                return _switchResult;
            }
            case "jeditor-line-color": {
                boolean _xblockexpression_2 = false;
                RGB rgb = this._cSSExtension.toRGB(value);
                boolean _xifexpression_1 = false;
                if (Objects.equal((Object)rgb, null)) {
                    return false;
                }
                boolean bl = true;
                boolean _notEquals = bl;
                if (!_notEquals) return false;
                boolean _xblockexpression_3 = false;
                HSB _hSB = new HSB(rgb.red, rgb.green, rgb.blue);
                els.setLineColor(_hSB);
                _xifexpression_1 = _xblockexpression_3 = true;
                _switchResult = _xblockexpression_2 = _xifexpression_1;
                return _switchResult;
            }
            case "jeditor-range-indicator-color": {
                boolean _xblockexpression_3 = false;
                RGB rgb = this._cSSExtension.toRGB(value);
                boolean _xifexpression_1 = false;
                if (Objects.equal((Object)rgb, null)) {
                    return false;
                }
                boolean bl = true;
                boolean _notEquals = bl;
                if (!_notEquals) return false;
                boolean _xtrycatchfinallyexpression = false;
                try {
                    boolean _xblockexpression_4 = false;
                    Field field = DefaultRangeIndicator.class.getDeclaredField("fgPaletteData");
                    field.setAccessible(true);
                    ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new RGB[]{rgb, rgb});
                    PaletteData paletteData = new PaletteData((RGB[])Conversions.unwrapArray((Object)_newArrayList, RGB.class));
                    field.set(DefaultRangeIndicator.class, paletteData);
                    _xtrycatchfinallyexpression = _xblockexpression_4 = true;
                }
                catch (Throwable _t) {
                    if (_t instanceof NoSuchFieldException) return false;
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                _xifexpression_1 = _xtrycatchfinallyexpression;
                _switchResult = _xblockexpression_3 = _xifexpression_1;
                return _switchResult;
            }
            default: {
                return false;
            }
        }
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        String _switchResult;
        String _xblockexpression;
        block18: {
            block16: {
                _xblockexpression = null;
                CompositeElement compositeElement = (CompositeElement)element;
                Object _nativeWidget = compositeElement.getNativeWidget();
                Composite composite = (Composite)_nativeWidget;
                if (!(composite instanceof StyledText)) {
                    return null;
                }
                StyledText styledText = (StyledText)composite;
                EditorLineSupport els = EditorLineSupport.get(styledText);
                _switchResult = null;
                if (property == null) break block16;
                switch (property) {
                    case "jeditor-line-style": {
                        String _switchResult_1 = null;
                        int _lineStyle = els.getLineStyle();
                        switch (_lineStyle) {
                            case 1: {
                                _switchResult_1 = "solid";
                                break;
                            }
                            case 2: {
                                _switchResult_1 = "dashed";
                                break;
                            }
                            case 3: {
                                _switchResult_1 = "dotted";
                                break;
                            }
                            default: {
                                _switchResult_1 = "none";
                            }
                        }
                        _switchResult = _switchResult_1;
                        break;
                    }
                    case "jeditor-line-color": {
                        _switchResult = els.getLineColor().toHTMLCode();
                        break;
                    }
                    default: {
                        _switchResult = null;
                        break;
                    }
                }
                break block18;
            }
            _switchResult = null;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }
}

