/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.css.internal.dynamicresource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import net.jeeeyul.eclipse.themes.css.internal.dynamicresource.DragHandleFactory;
import net.jeeeyul.eclipse.themes.css.internal.dynamicresource.FrameFactory;
import net.jeeeyul.eclipse.themes.css.internal.dynamicresource.JTResourceURI;
import net.jeeeyul.swtend.ui.HSB;
import org.eclipse.e4.ui.css.core.util.resources.IResourceLocator;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class JTDynamicResourceLocator
implements IResourceLocator {
    DragHandleFactory dragHandleFactory = new DragHandleFactory();
    FrameFactory frameFactory = new FrameFactory();

    public String resolve(String uri) {
        String[] segments;
        if (uri.startsWith("jeeeyul://") && (segments = uri.substring(9).split("/")).length > 0) {
            return uri;
        }
        return null;
    }

    public InputStream getInputStream(String uri) throws Exception {
        JTResourceURI curi = new JTResourceURI(uri);
        String command = curi.getCommand();
        if (command.equals("drag-handle")) {
            int height = Integer.parseInt(curi.getParameterValue("height", "22"));
            HSB backgroundColor = new HSB(curi.getParameterValue("background-color"));
            boolean rotated = Boolean.parseBoolean(curi.getParameterValue("rotated", "false"));
            boolean embossed = Boolean.parseBoolean(curi.getParameterValue("embossed", "false"));
            ImageData image = this.dragHandleFactory.create(height, backgroundColor, embossed, rotated);
            ImageLoader save = new ImageLoader();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            save.data = new ImageData[]{image};
            save.save((OutputStream)baos, 2);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        if (command.equals("frame")) {
            HSB hue = new HSB(curi.getParameterValue("background-color"));
            boolean rotated = Boolean.parseBoolean(curi.getParameterValue("rotated", "false"));
            ImageData image = this.frameFactory.create(hue, rotated);
            ImageLoader save = new ImageLoader();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            save.data = new ImageData[]{image};
            save.save((OutputStream)baos, 2);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        return null;
    }

    public Reader getReader(String uri) throws Exception {
        return new InputStreamReader(this.getInputStream(uri));
    }
}

