/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.css.internal.dynamicresource;

import java.util.ArrayList;
import net.jeeeyul.eclipse.themes.CoreImages;
import net.jeeeyul.swtend.ui.HSB;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;

public class DragHandleFactory {
    public ImageData create(int height, HSB backgroundColor, boolean embossed, boolean rotated) {
        ImageData source = null;
        source = embossed ? (rotated ? CoreImages.getImageDescriptor("icons/handle-embossed-rotated.gif").getImageData() : CoreImages.getImageDescriptor("icons/handle-embossed.gif").getImageData()) : (rotated ? CoreImages.getImageDescriptor("icons/handle-rotated.gif").getImageData() : CoreImages.getImageDescriptor("icons/handle.gif").getImageData());
        ImageData result = new ImageData(source.width, height, source.depth, source.palette);
        int offset = (result.height - source.height) / 2;
        int x = 0;
        while (x < result.width) {
            int y = 0;
            while (y < result.height) {
                if (y >= offset && y < offset + source.height) {
                    result.setPixel(x, y, source.getPixel(x, y - offset));
                } else {
                    result.setPixel(x, y, source.transparentPixel);
                }
                ++y;
            }
            ++x;
        }
        result.transparentPixel = source.transparentPixel;
        ArrayList<RGB> newRGBs = new ArrayList<RGB>();
        RGB[] rGBArray = result.palette.colors;
        int n = result.palette.colors.length;
        int n2 = 0;
        while (n2 < n) {
            RGB each = rGBArray[n2];
            try {
                HSB hsb = backgroundColor.getCopy();
                hsb.brightness = new HSB((RGB)each).brightness;
                hsb = hsb.mixWith(backgroundColor, 0.7f);
                newRGBs.add(hsb.toRGB());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        result.palette.colors = newRGBs.toArray(new RGB[newRGBs.size()]);
        return result;
    }
}

