/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.css.internal;

import java.lang.reflect.Field;
import java.util.Map;
import net.jeeeyul.eclipse.themes.internal.Debug;
import net.jeeeyul.swtend.ui.HSB;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.ui.css.core.css2.CSS2ColorHelper;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.progress.UIJob;

public class NamedColorHack {
    private static final String FIELD_NAME__COLOR_NAMES_MAP = "colorNamesMap";
    private static final String PLUGIN_ID__TEXT_EDITORS = "org.eclipse.ui.editors";
    public static final NamedColorHack INSTANCE = new NamedColorHack();
    private Map<String, String> namedColorMap;
    private UIJob updateJob;
    private IPreferenceStore fEditorStore;
    private IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            NamedColorHack.this.getUpdateJob().schedule(500L);
        }
    };

    private NamedColorHack() {
    }

    private IPreferenceStore getEditorStore() {
        if (this.fEditorStore == null) {
            this.fEditorStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_ID__TEXT_EDITORS);
        }
        return this.fEditorStore;
    }

    private HSB getHSBFromEditorPreference(String key) {
        String bgExp = this.getEditorStore().getString(key);
        if (bgExp == null || bgExp.trim().length() == 0) {
            return new HSB(0, 0, 0);
        }
        String[] segments = bgExp.split("[\\s,]+");
        int r = Integer.parseInt(segments[0], 10);
        int g = Integer.parseInt(segments[1], 10);
        int b = Integer.parseInt(segments[2], 10);
        HSB hsb = new HSB(r, g, b);
        return hsb;
    }

    private HSB getHSBFromSystemColor(int key) {
        return new HSB(Display.getDefault().getSystemColor(key).getRGB());
    }

    private Map<String, String> getNameColorMap() throws NoSuchFieldException, IllegalAccessException {
        if (this.namedColorMap == null) {
            Field mapField = CSS2ColorHelper.class.getDeclaredField(FIELD_NAME__COLOR_NAMES_MAP);
            mapField.setAccessible(true);
            this.namedColorMap = (Map)mapField.get(CSS2ColorHelper.class);
        }
        return this.namedColorMap;
    }

    private synchronized UIJob getUpdateJob() {
        if (this.updateJob == null) {
            this.updateJob = new UIJob(Display.getDefault(), "Update Named Colors"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    NamedColorHack.this.updateAll();
                    return Status.OK_STATUS;
                }
            };
            this.updateJob.setSystem(true);
            this.updateJob.setUser(false);
        }
        return this.updateJob;
    }

    public void start() {
        if (this.textEditorAvailable()) {
            this.getEditorStore().addPropertyChangeListener(this.listener);
            this.getUpdateJob().schedule();
        }
    }

    public void stop() {
        if (this.textEditorAvailable()) {
            this.getEditorStore().removePropertyChangeListener(this.listener);
        }
    }

    private boolean textEditorAvailable() {
        return Platform.getBundle((String)PLUGIN_ID__TEXT_EDITORS) != null;
    }

    private void update(String colorname, String defaultKey, int defaultSWTKey, String valueKey) {
        try {
            Map<String, String> map = this.getNameColorMap();
            if (this.getEditorStore().getBoolean(defaultKey)) {
                map.put(colorname, this.getHSBFromSystemColor(defaultSWTKey).toHTMLCode());
            } else {
                map.put(colorname, this.getHSBFromEditorPreference(valueKey).toHTMLCode());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateAll() {
        Debug.println("Start Updating Named Colors");
        this.update("jtexteditor-background", "AbstractTextEditor.Color.Background.SystemDefault", 25, "AbstractTextEditor.Color.Background");
        this.update("jtexteditor-foreground", "AbstractTextEditor.Color.Foreground.SystemDefault", 24, "AbstractTextEditor.Color.Foreground");
        this.update("jtexteditor-selection-background", "AbstractTextEditor.Color.SelectionBackground.SystemDefault", 26, "AbstractTextEditor.Color.SelectionBackground");
        this.update("jtexteditor-selection-foreground", "AbstractTextEditor.Color.SelectionForeground.SystemDefault", 27, "AbstractTextEditor.Color.SelectionForeground");
        Debug.println("Updating Named Colors is Done");
    }
}

