/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.css.internal;

import net.jeeeyul.eclipse.themes.internal.Debug;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.osgi.framework.Bundle;

public class EditBoxTracker {
    private static final String KEY_EDITBOX_ENABLEMENT = "ENABLED";
    private static final String PLUGINID_EDITBOX = "pm.eclipse.editbox";
    public static final EditBoxTracker INSTANCE = new EditBoxTracker();
    private boolean fIsTracking = false;
    private Boolean fEditBoxInstalled;
    private IPreferenceStore fEditBoxPreferenceStore;
    private Boolean fEditBoxIsActive = null;
    IPropertyChangeListener fEditBoxPreferenceStoreListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equalsIgnoreCase(EditBoxTracker.KEY_EDITBOX_ENABLEMENT)) {
                EditBoxTracker.this.fEditBoxIsActive = EditBoxTracker.this.getEditBoxPreferenceStore().getBoolean(EditBoxTracker.KEY_EDITBOX_ENABLEMENT);
                if (EditBoxTracker.this.editBoxEnablementHandler != null) {
                    EditBoxTracker.this.editBoxEnablementHandler.apply((Object)EditBoxTracker.this.fEditBoxIsActive);
                }
            }
        }
    };
    Procedures.Procedure1<Boolean> editBoxEnablementHandler;

    private EditBoxTracker() {
    }

    public synchronized void beginTrack() {
        if (this.fIsTracking) {
            return;
        }
        if (this.isEditBoxInstalled()) {
            this.hookEditBoxPreference();
        } else {
            Debug.println("Editbox is not installed");
        }
        this.fIsTracking = true;
        Debug.println("Tracking Edit Box Plugin was start");
    }

    private IPreferenceStore getEditBoxPreferenceStore() {
        if (this.fEditBoxPreferenceStore == null) {
            this.fEditBoxPreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGINID_EDITBOX);
        }
        return this.fEditBoxPreferenceStore;
    }

    private void hookEditBoxPreference() {
        IPreferenceStore store = this.getEditBoxPreferenceStore();
        store.addPropertyChangeListener(this.fEditBoxPreferenceStoreListener);
    }

    public boolean isEditBoxActive() {
        if (this.fEditBoxIsActive == null) {
            this.fEditBoxIsActive = !this.isEditBoxInstalled() ? Boolean.valueOf(false) : Boolean.valueOf(this.getEditBoxPreferenceStore().getBoolean(KEY_EDITBOX_ENABLEMENT));
        }
        return this.fEditBoxIsActive;
    }

    private boolean isEditBoxInstalled() {
        if (this.fEditBoxInstalled == null) {
            Bundle bundle = Platform.getBundle((String)PLUGINID_EDITBOX);
            if (bundle == null) {
                this.fEditBoxInstalled = false;
            } else {
                switch (bundle.getState()) {
                    case 4: 
                    case 8: 
                    case 32: {
                        this.fEditBoxInstalled = true;
                        break;
                    }
                    default: {
                        this.fEditBoxInstalled = false;
                    }
                }
            }
        }
        return this.fEditBoxInstalled;
    }

    public void setEditBoxEnablementHandler(Procedures.Procedure1<Boolean> editBoxEnablementHandler) {
        this.editBoxEnablementHandler = editBoxEnablementHandler;
    }

    public synchronized void stopTracking() {
        if (!this.fIsTracking) {
            return;
        }
        this.unhookEditBoxPreference();
        this.fIsTracking = false;
    }

    private void unhookEditBoxPreference() {
        this.getEditBoxPreferenceStore().removePropertyChangeListener(this.fEditBoxPreferenceStoreListener);
    }
}

