/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.css.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.widgets.Widget;

public class CSSClasses {
    private List<String> classes = new ArrayList<String>();

    public CSSClasses(String classNames) {
        if (classNames != null && !classNames.trim().isEmpty()) {
            String[] stringArray = classNames.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                this.classes.add(name);
                ++n2;
            }
        }
    }

    public void add(String ... classNames) {
        if (classNames == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = classNames;
        int n = classNames.length;
        int n2 = 0;
        while (n2 < n) {
            String each = stringArray[n2];
            String trimmed = each.trim();
            if (!this.classes.contains(trimmed)) {
                this.classes.add(trimmed);
            }
            ++n2;
        }
    }

    public boolean contains(String className) {
        if (className == null) {
            throw new IllegalArgumentException();
        }
        return this.classes.contains(className.trim());
    }

    public void remove(String ... classNames) {
        if (classNames == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = classNames;
        int n = classNames.length;
        int n2 = 0;
        while (n2 < n) {
            String each = stringArray[n2];
            String trimmed = each.trim();
            this.classes.remove(trimmed);
            ++n2;
        }
    }

    public static CSSClasses getStyleClasses(Widget w) {
        String literal = (String)w.getData("org.eclipse.e4.ui.css.CssClassName");
        return new CSSClasses(literal);
    }

    public static void setStyleClasses(Widget w, CSSClasses newStyleClasses) {
        w.setData("org.eclipse.e4.ui.css.CssClassName", (Object)newStyleClasses.toString());
    }

    public String toString() {
        if (this.classes.isEmpty()) {
            return "";
        }
        Iterator<String> iter = this.classes.iterator();
        StringBuilder sb = new StringBuilder(iter.next());
        while (iter.hasNext()) {
            sb.append(" ").append(iter.next());
        }
        return sb.toString();
    }
}

