/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes.css;

import java.util.HashSet;
import net.jeeeyul.eclipse.themes.css.internal.EditBoxTracker;
import net.jeeeyul.swtend.SWTExtensions;
import net.jeeeyul.swtend.ui.HSB;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.xtext.xbase.lib.Procedures;

public class EditorLineSupport {
    private static final SWTExtensions swtToolkit = SWTExtensions.INSTANCE;
    private static ILock GLOBAL_LOCK = Job.getJobManager().newLock();
    private static HashSet<EditorLineSupport> INSTANCES = new HashSet();
    private StyledText client;
    private HSB lineColor = HSB.BLACK;
    private int lineStyle = 0;
    private Image backgroundImage;
    private UIJob refreshJob;
    private boolean isDisposed = false;
    private Listener listener = new Listener(){

        public void handleEvent(Event event) {
            if (!EditorLineSupport.this.isDisposed) {
                EditorLineSupport.this.doHandle(event);
            }
        }
    };

    static {
        EditBoxTracker.INSTANCE.setEditBoxEnablementHandler(new Procedures.Procedure1<Boolean>(){

            public void apply(Boolean active) {
                if (!active.booleanValue()) {
                    for (EditorLineSupport each : INSTANCES) {
                        each.getRefreshJob().schedule();
                    }
                }
            }
        });
    }

    public static void disposeAll() {
        EditorLineSupport[] array;
        GLOBAL_LOCK.acquire();
        EditorLineSupport[] editorLineSupportArray = array = INSTANCES.toArray(new EditorLineSupport[INSTANCES.size()]);
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            EditorLineSupport each = editorLineSupportArray[n2];
            each.dispose();
            ++n2;
        }
        INSTANCES.clear();
        GLOBAL_LOCK.release();
    }

    public static EditorLineSupport get(StyledText client) {
        GLOBAL_LOCK.acquire();
        EditorLineSupport liner = (EditorLineSupport)client.getData(EditorLineSupport.class.getCanonicalName());
        if (liner == null) {
            liner = new EditorLineSupport(client);
        }
        GLOBAL_LOCK.release();
        return liner;
    }

    private EditorLineSupport(StyledText client) {
        this.client = client;
        INSTANCES.add(this);
        client.setData(EditorLineSupport.class.getCanonicalName(), (Object)this);
        this.hook();
    }

    private Image createNewBackgroundImage() {
        int width = 24;
        int height = this.client.getLineHeight();
        int offset = height - 1;
        if (this.client.getVerticalBar() != null) {
            offset = height - this.client.getVerticalBar().getSelection() % height - 1;
        }
        Image image = new Image((Device)this.client.getDisplay(), width, height);
        GC gc = new GC((Drawable)image);
        gc.setBackground(this.client.getBackground());
        gc.fillRectangle(0, 0, width, height);
        gc.setForeground(SWTExtensions.INSTANCE.toAutoDisposeColor(this.lineColor));
        gc.setAntialias(0);
        switch (this.lineStyle) {
            case 2: {
                gc.setLineStyle(2);
                gc.setLineDash(new int[]{2, 1});
                break;
            }
            case 3: {
                gc.setLineStyle(3);
                gc.setLineDash(new int[]{1, 2});
                break;
            }
            case 1: {
                break;
            }
        }
        gc.drawLine(0, offset, width, offset);
        gc.dispose();
        return image;
    }

    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        GLOBAL_LOCK.acquire();
        if (this.client != null && !this.client.isDisposed()) {
            this.client.setBackgroundImage(null);
            this.client.setData(EditorLineSupport.class.getCanonicalName(), null);
            this.unhook();
        }
        swtToolkit.safeDispose((Resource)this.backgroundImage);
        INSTANCES.remove(this);
        this.isDisposed = true;
        GLOBAL_LOCK.release();
    }

    private void doHandle(Event event) {
        switch (event.type) {
            case 12: {
                this.dispose();
                break;
            }
            case 13: {
                this.invalidate();
            }
        }
    }

    private void doRefresh() {
        if (this.client.isDisposed()) {
            return;
        }
        swtToolkit.safeDispose((Resource)this.backgroundImage);
        if (!EditBoxTracker.INSTANCE.isEditBoxActive()) {
            if (this.lineStyle == 0) {
                this.client.setBackgroundImage(null);
                this.dispose();
            } else {
                this.backgroundImage = this.createNewBackgroundImage();
                this.client.setBackgroundImage(this.backgroundImage);
            }
        }
    }

    public HSB getLineColor() {
        return this.lineColor;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    private UIJob getRefreshJob() {
        if (this.refreshJob == null) {
            this.refreshJob = new UIJob(Display.getDefault(), "Refersh Editor Line"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    EditorLineSupport.this.doRefresh();
                    return Status.OK_STATUS;
                }
            };
            this.refreshJob.setUser(false);
            this.refreshJob.setSystem(true);
        }
        return this.refreshJob;
    }

    private void hook() {
        this.client.addListener(12, this.listener);
        if (this.client.getVerticalBar() != null) {
            this.client.getVerticalBar().addListener(13, this.listener);
        }
    }

    private void invalidate() {
        this.getRefreshJob().schedule();
    }

    public void setLineColor(HSB lineColor) {
        if (this.lineColor == lineColor) {
            return;
        }
        if (this.lineColor != null && this.lineColor.equals((Object)lineColor)) {
            return;
        }
        this.lineColor = lineColor;
        this.invalidate();
    }

    public void setLineStyle(int lineStyle) {
        if (this.lineStyle == lineStyle) {
            return;
        }
        this.lineStyle = lineStyle;
        this.invalidate();
    }

    private void unhook() {
        this.client.removeListener(12, this.listener);
        if (this.client.getVerticalBar() != null) {
            this.client.getVerticalBar().removeListener(13, this.listener);
        }
    }
}

