/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes;

import javax.annotation.PreDestroy;
import javax.inject.Inject;
import net.jeeeyul.eclipse.themes.css.internal.CSSClasses;
import net.jeeeyul.eclipse.themes.internal.Debug;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class EmptyPartStackProcessor {
    @Inject
    IEventBroker broker;
    @Inject
    IStylingEngine engine;
    @Inject
    EModelService modelService;
    private EventHandler widgetAssignListener = new EventHandler(){

        public void handleEvent(Event event) {
            if (!UIEvents.isSET((Event)event)) {
                return;
            }
            Object e = event.getProperty("ChangedElement");
            if (e instanceof MPartStack) {
                MPartStack ps = (MPartStack)e;
                EmptyPartStackProcessor.this.applyEmptyTag(ps);
            }
        }
    };
    private EventHandler modelChildrenListener = new EventHandler(){

        public void handleEvent(Event event) {
            Object parent;
            if ((UIEvents.isADD((Event)event) || UIEvents.isREMOVE((Event)event)) && (parent = event.getProperty("ChangedElement")) instanceof MPartStack) {
                MPartStack stack = (MPartStack)parent;
                EmptyPartStackProcessor.this.applyTagsAndClasses(stack);
            }
        }
    };
    private EventHandler toggleViewVisibilityListener = new EventHandler(){

        public void handleEvent(Event event) {
            MPlaceholder placeholder;
            MElementContainer parent;
            Object sender = event.getProperty("ChangedElement");
            if (sender instanceof MPlaceholder && (parent = (placeholder = (MPlaceholder)sender).getParent()) instanceof MPartStack) {
                EmptyPartStackProcessor.this.applyTagsAndClasses((MPartStack)parent);
            }
        }
    };

    private void applyEmptyTag(MPartStack stack) {
        boolean hasEmptyTag = stack.getTags().contains("empty");
        boolean hasChild = this.hasVisibleChild(stack);
        if (!hasChild && !hasEmptyTag) {
            stack.getTags().add("empty");
        } else if (hasEmptyTag && hasChild) {
            stack.getTags().remove("empty");
        }
    }

    private void applyTagsAndClasses(MPartStack stack) {
        Widget widget = (Widget)stack.getWidget();
        if (widget == null || widget.isDisposed()) {
            return;
        }
        CSSClasses styleClasses = CSSClasses.getStyleClasses(widget);
        boolean hasEmptyTag = stack.getTags().contains("empty");
        boolean hasChild = this.hasVisibleChild(stack);
        if (!hasChild && !hasEmptyTag) {
            stack.getTags().add("empty");
            styleClasses.add("empty");
            this.engine.setClassname((Object)widget, styleClasses.toString());
            Debug.println("New Empty Part Stack Found!");
        } else if (hasEmptyTag && hasChild) {
            stack.getTags().remove("empty");
            styleClasses.remove("empty");
            this.engine.setClassname((Object)widget, styleClasses.toString());
            Debug.println("Empty Part Stack about to have a new child");
        }
    }

    @PreDestroy
    public void dispose() {
        this.broker.unsubscribe(this.widgetAssignListener);
        this.broker.unsubscribe(this.modelChildrenListener);
        Debug.println("Empty Part Stack Processor is stopped.");
    }

    @Execute
    public void execute(MApplication app) {
        Debug.println("Empty Part Stack Processor is started");
        this.broker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/widget/*", this.widgetAssignListener);
        this.broker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", this.modelChildrenListener);
        this.broker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*", this.toggleViewVisibilityListener);
    }

    private boolean hasVisibleChild(MPartStack stack) {
        boolean hasChild = IterableExtensions.exists((Iterable)stack.getChildren(), (Functions.Function1)new Functions.Function1<MStackElement, Boolean>(){

            public Boolean apply(MStackElement e) {
                return e.isToBeRendered();
            }
        });
        return hasChild;
    }
}

