/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes;

import javax.inject.Inject;
import net.jeeeyul.eclipse.themes.css.internal.dynamicresource.JTDynamicResourceLocator;
import net.jeeeyul.eclipse.themes.internal.Debug;
import net.jeeeyul.eclipse.themes.internal.ENVHelper;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.util.resources.IResourceLocator;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.swt.widgets.Display;

public class DynamicResourceProcessor {
    @Inject
    IEclipseContext ctx;

    @Execute
    public void trackThemeInstance() {
        Debug.println("DynamicResourceProcessor Started.");
        this.ctx.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                boolean tryNext = !DynamicResourceProcessor.this.tryToInstall(context);
                return tryNext;
            }
        });
    }

    private boolean tryToInstall(IEclipseContext context) {
        CSSEngine cssEngine;
        context.get(IContributionFactory.class.getName());
        IStylingEngine stylingEngine = (IStylingEngine)context.get(IStylingEngine.class);
        IThemeEngine themeEngine = (IThemeEngine)context.get(IThemeEngine.class);
        if (themeEngine != null) {
            CSSEngine cssEngine2;
            themeEngine.registerResourceLocator((IResourceLocator)new JTDynamicResourceLocator(), new String[0]);
            Debug.println("Dynamic Resource Locator is installed on Theme Engine");
            if (!ENVHelper.INSTANCE.isLinux() && (cssEngine2 = WidgetElement.getEngine((Display)Display.getDefault())) != null) {
                cssEngine2.getResourcesLocatorManager().registerResourceLocator((IResourceLocator)new JTDynamicResourceLocator());
                Debug.println("Dynamic Resource Locator is installed on CSS Engine");
                return true;
            }
            return true;
        }
        if (stylingEngine != null && (cssEngine = WidgetElement.getEngine((Display)Display.getDefault())) != null) {
            cssEngine.getResourcesLocatorManager().registerResourceLocator((IResourceLocator)new JTDynamicResourceLocator());
            Debug.println("Dynamic Resource Locator is installed on CSS Engine");
            return true;
        }
        return false;
    }
}

