/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.eclipse.themes;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class CoreImages {
    public static final String FRAME_ROTATED = "icons/frame-rotated.gif";
    public static final String FRAME = "icons/frame.gif";
    public static final String HANDLE_EMBOSSED_ROTATED = "icons/handle-embossed-rotated.gif";
    public static final String HANDLE_EMBOSSED = "icons/handle-embossed.gif";
    public static final String HANDLE_ROTATED = "icons/handle-rotated.gif";
    public static final String HANDLE = "icons/handle.gif";
    public static final String TRANSPARENT = "icons/transparent.gif";
    public static final String WAITING = "icons/waiting.png";
    private static final ImageRegistry REGISTRY = new ImageRegistry(Display.getDefault());

    public static synchronized Image getImage(String key) {
        Image result = REGISTRY.get(key);
        if (result == null) {
            ImageDescriptor descriptor = CoreImages.loadImageDescriptor(key);
            result = descriptor.createImage();
            REGISTRY.put(key, result);
        }
        return result;
    }

    public static synchronized ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor result = REGISTRY.getDescriptor(key);
        if (result == null) {
            result = CoreImages.loadImageDescriptor(key);
            REGISTRY.put(key, result);
        }
        return result;
    }

    private static ImageDescriptor loadImageDescriptor(String key) {
        try {
            Bundle bundle = Platform.getBundle((String)"net.jeeeyul.eclipse.themes");
            URL resource = null;
            resource = bundle != null ? Platform.getBundle((String)"net.jeeeyul.eclipse.themes").getResource(key) : new File(key).toURI().toURL();
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)resource);
            return descriptor;
        }
        catch (Exception e) {
            e.printStackTrace();
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_ERROR_TSK");
        }
    }
}

