/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.reboot.license;

import com.mulesoft.licm.EnterpriseLicenseKey;
import com.mulesoft.licm.LicenseKeyException;
import com.mulesoft.licm.LicenseManagementFactory;
import com.mulesoft.licm.LicenseManager;
import com.mulesoft.mule.runtime.module.boot.license.LicenseKey;
import com.mulesoft.mule.runtime.module.boot.license.LicenseProvider;
import com.mulesoft.mule.runtime.module.boot.license.MuleLicenseException;
import com.mulesoft.mule.runtime.module.reboot.license.LicenseException;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LicenseKeyHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseKeyHandler.class);
    private LicenseManager licenseManager;

    public LicenseKeyHandler() {
        try {
            this.licenseManager = LicenseManagementFactory.getInstance().createLicenseManager("mule-ee");
        }
        catch (LicenseKeyException e) {
            LOGGER.error("Error creating License Manager!", (Throwable)e);
            throw new IllegalStateException();
        }
    }

    public EnterpriseLicenseKey install(EnterpriseLicenseKey key) throws LicenseException {
        EnterpriseLicenseKey installedKey;
        try {
            this.licenseManager.unInstall();
            this.licenseManager.install(key);
            installedKey = this.licenseManager.validate("mule-ee");
        }
        catch (LicenseKeyException e) {
            LOGGER.error("Couldn't install license key!", (Throwable)e);
            throw new LicenseException("Couldn't install license key!", e);
        }
        return installedKey;
    }

    public void unInstall() throws LicenseException {
        try {
            this.licenseManager.unInstall();
        }
        catch (LicenseKeyException e) {
            LOGGER.error("Couldn't uninstall license key!", (Throwable)e);
            throw new LicenseException("Couldn't uninstall license key!", e);
        }
    }

    public synchronized LicenseKey validate() throws LicenseException {
        try {
            return LicenseProvider.getLicenseProvider().getLicenseKey("mule-ee");
        }
        catch (MuleLicenseException e) {
            throw new LicenseException("Couldn't validate license key!", e.getCause());
        }
    }

    public synchronized EnterpriseLicenseKey verify(File licenseFile) throws LicenseException {
        EnterpriseLicenseKey key = null;
        try {
            key = this.licenseManager.verify("mule-ee", licenseFile);
        }
        catch (LicenseKeyException e) {
            throw new LicenseException("Couldn't validate license key!", e);
        }
        return key;
    }
}

