/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Page<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<T> items;
    private final Serializable nextPage;

    public Page(List<T> items, Serializable nextPage) {
        this.items = Collections.unmodifiableList(items);
        this.nextPage = nextPage;
    }

    public List<T> getItems() {
        return this.items;
    }

    public Optional<Serializable> getNextPage() {
        return Optional.ofNullable(this.nextPage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("Page: items=").append(this.items);
        if (this.nextPage != null) {
            sb.append(", nextPage=").append(this.nextPage);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page page = (Page)o;
        return Objects.equals(this.items, page.items) && Objects.equals(this.nextPage, page.nextPage);
    }

    public static <I> PageFactory<I> factory() {
        return new PageFactory();
    }

    public int hashCode() {
        return Objects.hash(this.items, this.nextPage);
    }

    public static class PageFactory<I>
    extends AbstractPageFactory<Page<I>, I> {
        @Override
        public Page<I> fromNotPaginatedData(Object data, Function<Object, I> buildItem) {
            return new Page<I>(PageFactory.mapList((List)data, buildItem), null);
        }

        @Override
        public Page<I> fromPaginatedData(Object data, Function<Object, ? extends I> buildItem) {
            Map pageMap = (Map)data;
            return new Page<I>(PageFactory.mapList((List)pageMap.get("items"), buildItem), (Serializable)pageMap.get("nextPage"));
        }
    }

    protected static abstract class AbstractPageFactory<P extends Page<I>, I> {
        protected AbstractPageFactory() {
        }

        public Function<Object, P> getBuilderFunction(boolean paginated, Function<Object, I> buildItem) {
            return paginated ? data -> this.fromPaginatedData(data, buildItem) : data -> this.fromNotPaginatedData(data, buildItem);
        }

        public abstract P fromNotPaginatedData(Object var1, Function<Object, I> var2);

        public abstract P fromPaginatedData(Object var1, Function<Object, ? extends I> var2);

        protected static <P, Q> List<Q> mapList(List<P> l, Function<? super P, ? extends Q> buildItem) {
            return l.stream().map(buildItem).collect(Collectors.toList());
        }
    }
}

