/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.metadata;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.wsdl.Part;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.service.soap.metadata.NodeMetadataResolver;
import org.mule.service.soap.util.SoapServiceMetadataTypeUtils;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.operation.OperationModel;

abstract class BodyMetadataResolver
extends NodeMetadataResolver {
    BodyMetadataResolver(PortModel port, TypeLoader loader, Function<OperationModel, Optional<Part>> partRetriever) {
        super(port, loader, partRetriever);
    }

    @Override
    public MetadataType getMetadata(String operation) throws MetadataResolvingException {
        Part bodyPart = this.getBodyPart(operation);
        MetadataType bodyType = this.buildPartMetadataType(bodyPart);
        List<ObjectFieldType> attachmentFields = SoapServiceMetadataTypeUtils.getAttachmentFields(bodyType);
        return this.filterAttachmentsFromBodyType(bodyType, attachmentFields);
    }

    private MetadataType filterAttachmentsFromBodyType(MetadataType bodyType, List<ObjectFieldType> attachments) {
        if (!attachments.isEmpty() && bodyType instanceof ObjectType) {
            ObjectType operationType = SoapServiceMetadataTypeUtils.getOperationType(bodyType);
            attachments.forEach(a -> operationType.getFields().removeIf(f -> MetadataTypeUtils.getLocalPart((ObjectFieldType)f).equals(MetadataTypeUtils.getLocalPart((ObjectFieldType)a))));
            if (operationType.getFields().isEmpty()) {
                return this.nullType;
            }
        }
        return bodyType;
    }
}

