/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.client;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.message.Attachment;
import org.mule.runtime.extension.api.soap.SoapAttachment;
import org.mule.runtime.soap.api.exception.BadRequestException;
import org.mule.service.soap.util.AttachmentsUtils;

class CxfAttachmentsFactory {
    private boolean isMtom;

    CxfAttachmentsFactory(boolean isMtom) {
        this.isMtom = isMtom;
    }

    public Map<String, Attachment> transformToCxfAttachments(Map<String, SoapAttachment> attachments) {
        if (!this.isMtom) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        attachments.forEach((name, value) -> {
            try {
                AttachmentImpl attachment = new AttachmentImpl(name, AttachmentsUtils.toDataHandler(name, value.getContent(), value.getContentType()));
                attachment.setHeader("Content-Disposition", "attachment; name=\"" + name + "\"");
                builder.put(name, (Object)attachment);
            }
            catch (IOException e) {
                throw new BadRequestException(String.format("Error while preparing attachment [%s] for upload", name), (Throwable)e);
            }
        });
        return builder.build();
    }
}

