/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.wizard.apis.ui.components;

import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.mule.alsp.wizard.apis.core.model.APISpecFormat;
import org.mule.alsp.wizard.apis.core.model.APISpecType;
import org.mule.alsp.wizard.apis.core.model.APISpecVersion;
import org.mule.alsp.wizard.apis.core.model.APISpecification;
import org.mule.alsp.wizard.apis.ui.components.IAPISpecificationComponent;

public class RAMLSpecificationComponent
implements IAPISpecificationComponent {
    private APISpecType apiSpecType;
    private APISpecVersion apiSpecVersion;
    private APISpecFormat apiSpecFormat;

    public RAMLSpecificationComponent() {
        this.setDefaults();
    }

    private void setDefaults() {
        this.apiSpecType = APISpecType.RAML;
        this.apiSpecVersion = APISpecVersion.V_1_0_0;
        this.apiSpecFormat = APISpecFormat.RAML;
    }

    public Composite createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(container);
        this.addVersionField(container);
        return container;
    }

    private void addVersionField(Composite container) {
        Label versionLabel = new Label(container, 0);
        versionLabel.setText("Version");
        ComboViewer versionCombo = new ComboViewer(container, 8);
        versionCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        versionCombo.setLabelProvider((IBaseLabelProvider)APISpecVersion.asLabelProvider());
        versionCombo.setInput(Arrays.asList(APISpecVersion.V_1_0_0, APISpecVersion.V_0_8_0));
        versionCombo.addSelectionChangedListener(e -> {
            IStructuredSelection selection = e.getStructuredSelection();
            this.apiSpecVersion = (APISpecVersion)selection.getFirstElement();
        });
        versionCombo.setSelection((ISelection)new StructuredSelection(versionCombo.getElementAt(0)));
    }

    @Override
    public void onFormatChange(Consumer<APISpecFormat> operation) {
        operation.accept(this.apiSpecFormat);
    }

    @Override
    public APISpecification get() {
        return new APISpecification(this.apiSpecType, this.apiSpecVersion, this.apiSpecFormat);
    }
}

