/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.wizard.apis.ui.components;

import java.util.function.Consumer;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.mule.alsp.wizard.apis.core.model.APISpecFormat;
import org.mule.alsp.wizard.apis.core.model.APISpecification;
import org.mule.alsp.wizard.apis.ui.components.IAPISpecificationComponent;
import org.mule.alsp.wizard.apis.ui.components.OpenAPISpecificationComponent;
import org.mule.alsp.wizard.apis.ui.components.RAMLSpecificationComponent;

public class APISpecificationComponent
implements IAPISpecificationComponent {
    private CTabFolder tabFolder;
    private OpenAPISpecificationComponent openAPIComponent;
    private RAMLSpecificationComponent ramlComponent;
    private Consumer<APISpecFormat> onFormatChangeOperation;

    public APISpecificationComponent(Consumer<APISpecFormat> onFormatChangeOperation) {
        this.onFormatChangeOperation = onFormatChangeOperation;
    }

    public void createControl(Composite parent) {
        Label specTitle = new Label(parent, 0);
        specTitle.setText("Select your type of API Specification:");
        this.createAPISpecTabFolder(parent);
    }

    private void createAPISpecTabFolder(Composite parent) {
        this.tabFolder = new CTabFolder(parent, 0);
        GridDataFactory.fillDefaults().span(2, 0).grab(true, false).applyTo((Control)this.tabFolder);
        CTabItem oasTabItem = this.createOASTab(this.tabFolder);
        this.createRAMLTab(this.tabFolder);
        this.tabFolder.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.onFormatChange(this.onFormatChangeOperation)));
        this.tabFolder.setSelection(oasTabItem);
        this.onFormatChange(this.onFormatChangeOperation);
    }

    private CTabItem createOASTab(CTabFolder tabFolder) {
        Composite oasTab = this.createOASTabContent((Composite)tabFolder);
        CTabItem oasTabItem = new CTabItem(tabFolder, 0);
        oasTabItem.setText("OpenAPI");
        oasTabItem.setControl((Control)oasTab);
        oasTabItem.setData((Object)this.openAPIComponent);
        return oasTabItem;
    }

    private CTabItem createRAMLTab(CTabFolder tabFolder) {
        Composite ramlTab = this.createRAMLTabContent((Composite)tabFolder);
        CTabItem ramlTabItem = new CTabItem(tabFolder, 0);
        ramlTabItem.setText("RAML");
        ramlTabItem.setControl((Control)ramlTab);
        ramlTabItem.setData((Object)this.ramlComponent);
        return ramlTabItem;
    }

    private Composite createOASTabContent(Composite parentTabFolder) {
        this.openAPIComponent = new OpenAPISpecificationComponent();
        return this.openAPIComponent.createControl(parentTabFolder);
    }

    private Composite createRAMLTabContent(Composite parent) {
        this.ramlComponent = new RAMLSpecificationComponent();
        return this.ramlComponent.createControl(parent);
    }

    @Override
    public void onFormatChange(Consumer<APISpecFormat> operation) {
        IAPISpecificationComponent apiSpecProvider = (IAPISpecificationComponent)this.tabFolder.getSelection().getData();
        apiSpecProvider.onFormatChange(operation);
    }

    @Override
    public APISpecification get() {
        IAPISpecificationComponent apiSpecProvider = (IAPISpecificationComponent)this.tabFolder.getSelection().getData();
        return apiSpecProvider.get();
    }
}

