/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.wizard.apis.ui.components;

import java.util.Arrays;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.mule.alsp.wizard.apis.core.model.APIFragment;
import org.mule.alsp.wizard.apis.core.model.APIFragmentType;
import org.mule.alsp.wizard.apis.core.model.APISpecFormat;
import org.mule.alsp.wizard.apis.core.model.APISpecType;
import org.mule.alsp.wizard.apis.core.model.APISpecVersion;
import org.mule.alsp.wizard.apis.core.model.APISpecification;

public class APIFragmentComponent {
    private APIFragmentType apiFragmentType;

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(container);
        GridDataFactory.fillDefaults().applyTo((Control)container);
        this.addTypeField(container);
    }

    private void addTypeField(Composite container) {
        Label typeLabel = new Label(container, 0);
        typeLabel.setText("Fragment type");
        ComboViewer typeCombo = new ComboViewer(container, 8);
        typeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        typeCombo.setLabelProvider((IBaseLabelProvider)APIFragmentType.asLabelProvider());
        typeCombo.setInput(Arrays.asList(APIFragmentType.ANNOTATION_TYPE_DECLARATION, APIFragmentType.DATA_TYPE, APIFragmentType.NAMED_EXAMPLE, APIFragmentType.EXTENSION, APIFragmentType.LIBRARY, APIFragmentType.OVERLAY, APIFragmentType.RESOURCE_TYPE, APIFragmentType.SECURITY_SCHEME, APIFragmentType.TRAIT, APIFragmentType.DOCUMENTATION_ITEM));
        typeCombo.addSelectionChangedListener(e -> {
            IStructuredSelection selection = e.getStructuredSelection();
            this.apiFragmentType = (APIFragmentType)selection.getFirstElement();
        });
        typeCombo.setSelection((ISelection)new StructuredSelection(typeCombo.getElementAt(8)));
    }

    public APIFragment get() {
        APISpecification raml10spec = new APISpecification(APISpecType.RAML, APISpecVersion.V_1_0_0, APISpecFormat.RAML);
        APIFragment apiFragment = new APIFragment(raml10spec, this.apiFragmentType);
        return apiFragment;
    }
}

