/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.wizard.apis.ui;

import java.util.function.Consumer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.mule.alsp.extensions.newapilocation.INewAPIFileLocationProvider;
import org.mule.alsp.wizard.apis.core.model.APISpecFormat;
import org.mule.alsp.wizard.apis.core.model.APISpecification;
import org.mule.alsp.wizard.apis.ui.NewApiFileWizardPage;
import org.mule.alsp.wizard.apis.ui.components.APISpecificationComponent;

public class NewApiSpecificationFileWizardPage
extends NewApiFileWizardPage {
    private APISpecificationComponent apiSpecificationComponent;

    public NewApiSpecificationFileWizardPage(IStructuredSelection selection, INewAPIFileLocationProvider initialLocationProvider) {
        super("Create new API Specification file", selection, initialLocationProvider);
        this.setTitle("Create new API Specification file");
        this.setDescription("Specify the options to create a new API Specification file");
    }

    @Override
    protected void createAPIValuesControl(Composite parent) {
        Consumer<APISpecFormat> onFormatChange = this.updateFileExtension();
        this.apiSpecificationComponent = new APISpecificationComponent(onFormatChange);
        this.apiSpecificationComponent.createControl(parent);
    }

    public APISpecification get() {
        try {
            return this.apiSpecificationComponent.get();
        }
        catch (Exception e) {
            this.setErrorMessage("An error occured creating file: " + e.getMessage());
            throw e;
        }
    }

    private Consumer<APISpecFormat> updateFileExtension() {
        return format -> {
            String filename = this.calculateFilename((APISpecFormat)format);
            String filenameExtension = this.calculateFilenameExtension((APISpecFormat)format);
            this.setFileName(filename);
            this.setFileExtension(filenameExtension);
        };
    }

    private String calculateFilename(APISpecFormat format) {
        String currentFilename = this.getFileName();
        if (currentFilename != null && currentFilename.endsWith("." + this.getFileExtension())) {
            int extensionStartingIndex = currentFilename.lastIndexOf(46);
            String filenameWithoutExtension = currentFilename.substring(0, extensionStartingIndex);
            return format.completeFilenameWithExtension(filenameWithoutExtension);
        }
        return currentFilename;
    }
}

