/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.wizard.apis.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.mule.alsp.ALSPlugin;
import org.mule.alsp.extensions.newapilocation.INewAPIFileLocationProvider;
import org.mule.alsp.extensions.newapilocation.NewAPIFileLocationProviderManager;
import org.mule.alsp.ui.APIEditorImages;
import org.mule.alsp.ui.UiUtils;
import org.mule.alsp.wizard.apis.core.filecreator.APIFileCreator;
import org.mule.alsp.wizard.apis.core.filecreator.TemplateBasedAPIFileCreator;
import org.mule.alsp.wizard.apis.core.model.APISpecification;
import org.mule.alsp.wizard.apis.core.template.InMemoryAPITemplateFactory;
import org.mule.alsp.wizard.apis.ui.NewApiSpecificationFileWizardPage;

public class NewApiSpecificationFileWizard
extends Wizard
implements INewWizard {
    private APIFileCreator apiFileCreator;
    private NewApiSpecificationFileWizardPage page;
    private IStructuredSelection initialSelection;
    private INewAPIFileLocationProvider initialLocationProvider;

    public NewApiSpecificationFileWizard() {
        InMemoryAPITemplateFactory apiTemplateFactory = new InMemoryAPITemplateFactory();
        this.apiFileCreator = new TemplateBasedAPIFileCreator(apiTemplateFactory);
        this.initialLocationProvider = NewAPIFileLocationProviderManager.instance().getInitialLocationProvider();
        this.setWindowTitle("New API Specification File");
        this.setDefaultPageImageDescriptor(APIEditorImages.DESC_NEW_API_SPEC_FILE_BANNER);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.initialSelection = selection;
    }

    public void addPages() {
        this.page = new NewApiSpecificationFileWizardPage(this.initialSelection, this.initialLocationProvider);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        try {
            IFile apiFileCreated = this.createNewAPIFile();
            UiUtils.openEditorForFile(apiFileCreated);
        }
        catch (Exception e) {
            ALSPlugin.logError("Could not create API file", e);
            return false;
        }
        return true;
    }

    private IFile createNewAPIFile() {
        IFile destinationFile = this.page.createNewFile();
        APISpecification apiSpecification = this.page.get();
        this.apiFileCreator.create(destinationFile, apiSpecification);
        return destinationFile;
    }
}

