/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.wizard.apis.ui;

import java.util.Optional;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.mule.alsp.extensions.newapilocation.INewAPIFileLocationProvider;
import org.mule.alsp.wizard.apis.core.model.APISpecFormat;

public abstract class NewApiFileWizardPage
extends WizardNewFileCreationPage {
    private Optional<IContainer> selectionContainer;
    private INewAPIFileLocationProvider initialLocationProvider;

    public NewApiFileWizardPage(String pageName, IStructuredSelection selection, INewAPIFileLocationProvider initialLocationProvider) {
        super(pageName, selection);
        this.selectionContainer = this.getContainer(selection);
        this.initialLocationProvider = initialLocationProvider;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(container);
        Group apiValuesGroup = this.createAPIValuesGroup(container);
        this.createAPIValuesControl((Composite)apiValuesGroup);
        Group locationGroup = this.createLocationGroup(container);
        this.createLocationControl((Composite)locationGroup);
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    protected Group createAPIValuesGroup(Composite container) {
        Group apiValuesGroup = new Group(container, 0);
        GridLayoutFactory.fillDefaults().applyTo((Composite)apiValuesGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)apiValuesGroup);
        return apiValuesGroup;
    }

    protected Group createLocationGroup(Composite container) {
        Group locationGroup = new Group(container, 0);
        GridLayoutFactory.fillDefaults().applyTo((Composite)locationGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)locationGroup);
        return locationGroup;
    }

    protected abstract void createAPIValuesControl(Composite var1);

    protected void createLocationControl(Composite parent) {
        super.createControl(parent);
        this.adjustLocationLayoutData();
        this.setContainerFullPath(this.getInitialDestinationPath());
    }

    protected void adjustLocationLayoutData() {
        Control locationControl = super.getControl();
        GridData locationGridData = (GridData)locationControl.getLayoutData();
        locationGridData.grabExcessHorizontalSpace = true;
        locationGridData.grabExcessVerticalSpace = true;
    }

    protected void createAdvancedControls(Composite parent) {
    }

    protected void createLinkTarget() {
    }

    protected IStatus validateLinkedResource() {
        return Status.OK_STATUS;
    }

    protected String calculateFilenameExtension(APISpecFormat format) {
        String exampleFilename = format.completeFilenameWithExtension("example");
        return exampleFilename.replace("example.", "");
    }

    private Optional<IContainer> getContainer(IStructuredSelection selection) {
        Object selected = selection.getFirstElement();
        if (selected == null) {
            return Optional.empty();
        }
        IContainer container = null;
        if (selected instanceof IFile) {
            container = ((IFile)selected).getParent();
        } else if (selected instanceof IContainer) {
            container = (IContainer)selected;
        }
        if (container == null || !container.isAccessible()) {
            return Optional.empty();
        }
        return Optional.of(container);
    }

    private IPath getInitialDestinationPath() {
        Optional<IPath> contributedInitialLocation = this.getContributedInitialDestinationPath();
        if (contributedInitialLocation.isPresent()) {
            return contributedInitialLocation.get();
        }
        return this.getDefaultInitialDestinationPath();
    }

    private Optional<IPath> getContributedInitialDestinationPath() {
        if (this.initialLocationProvider == null) {
            return Optional.empty();
        }
        if (this.selectionContainer.isPresent()) {
            return this.initialLocationProvider.getInitialLocation(this.selectionContainer.get());
        }
        return this.initialLocationProvider.getInitialLocation();
    }

    private IPath getDefaultInitialDestinationPath() {
        if (this.selectionContainer.isPresent()) {
            return this.selectionContainer.get().getFullPath();
        }
        return Path.fromOSString((String)"");
    }
}

