/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.wizard.apis.core.template;

import java.util.HashMap;
import java.util.Map;
import org.mule.alsp.wizard.apis.core.model.APIFragment;
import org.mule.alsp.wizard.apis.core.model.APIFragmentType;
import org.mule.alsp.wizard.apis.core.model.APISpecFormat;
import org.mule.alsp.wizard.apis.core.model.APISpecType;
import org.mule.alsp.wizard.apis.core.model.APISpecVersion;
import org.mule.alsp.wizard.apis.core.model.APISpecification;
import org.mule.alsp.wizard.apis.core.template.APITemplate;
import org.mule.alsp.wizard.apis.core.template.APITemplateFactory;
import org.mule.alsp.wizard.apis.core.template.EmptyAPITemplate;

public class InMemoryAPITemplateFactory
implements APITemplateFactory {
    private static final String SWAGGER_2_0_YAML_TEMPLATE = "swagger: \"2.0\"\ninfo:\n  title: <YOUR_TITLE>\n  version: v1\npaths: {}\n";
    private static final String SWAGGER_2_0_JSON_TEMPLATE = "{\n  \"swagger\": \"2.0\",\n  \"info\": {\n    \"title\": \"<YOUR_TITLE>\",\n    \"version\": \"v1\"\n  },\n  \"paths\": {}\n}";
    private static final String OPENAPI_3_0_YAML_TEMPLATE = "openapi: \"3.0.0\"\ninfo:\n  title: <YOUR_TITLE>\n  version: v1\npaths: {}\n";
    private static final String OPENAPI_3_0_JSON_TEMPLATE = "{\n  \"openapi\": \"3.0.0\",\n  \"info\": {\n    \"title\": \"<YOUR_TITLE>\",\n    \"version\": \"v1\"\n  },\n  \"paths\": {}\n}";
    private static final String RAML_0_8_TEMPLATE = "#%RAML 0.8\ntitle: <YOUR_TITLE>\nversion: v1";
    private static final String RAML_1_0_TEMPLATE = "#%RAML 1.0\ntitle: <YOUR_TITLE>\nversion: v1";
    private static final Map<APISpecification, String> specificationTemplates;
    private static final Map<APIFragment, String> fragmentTemplates;

    static {
        APISpecification raml10 = new APISpecification(APISpecType.RAML, APISpecVersion.V_1_0_0, APISpecFormat.RAML);
        specificationTemplates = new HashMap<APISpecification, String>();
        specificationTemplates.put(new APISpecification(APISpecType.OPENAPI, APISpecVersion.V_2_0_0, APISpecFormat.YAML), SWAGGER_2_0_YAML_TEMPLATE);
        specificationTemplates.put(new APISpecification(APISpecType.OPENAPI, APISpecVersion.V_2_0_0, APISpecFormat.JSON), SWAGGER_2_0_JSON_TEMPLATE);
        specificationTemplates.put(new APISpecification(APISpecType.OPENAPI, APISpecVersion.V_3_0_0, APISpecFormat.YAML), OPENAPI_3_0_YAML_TEMPLATE);
        specificationTemplates.put(new APISpecification(APISpecType.OPENAPI, APISpecVersion.V_3_0_0, APISpecFormat.JSON), OPENAPI_3_0_JSON_TEMPLATE);
        specificationTemplates.put(new APISpecification(APISpecType.RAML, APISpecVersion.V_0_8_0, APISpecFormat.RAML), RAML_0_8_TEMPLATE);
        specificationTemplates.put(raml10, RAML_1_0_TEMPLATE);
        fragmentTemplates = new HashMap<APIFragment, String>();
        fragmentTemplates.put(new APIFragment(raml10, APIFragmentType.ANNOTATION_TYPE_DECLARATION), "#%RAML 1.0 AnnotationTypeDeclaration");
        fragmentTemplates.put(new APIFragment(raml10, APIFragmentType.DATA_TYPE), "#%RAML 1.0 DataType");
        fragmentTemplates.put(new APIFragment(raml10, APIFragmentType.DOCUMENTATION_ITEM), "#%RAML 1.0 DocumentationItem\ntitle: <YOUR_TITLE>\ncontent: <YOUR_DOCUMENTATION>");
        fragmentTemplates.put(new APIFragment(raml10, APIFragmentType.EXTENSION), "#%RAML 1.0 Extension\nextends: <PATH_TO_RAML>");
        fragmentTemplates.put(new APIFragment(raml10, APIFragmentType.LIBRARY), "#%RAML 1.0 Library");
        fragmentTemplates.put(new APIFragment(raml10, APIFragmentType.NAMED_EXAMPLE), "#%RAML 1.0 NamedExample");
        fragmentTemplates.put(new APIFragment(raml10, APIFragmentType.OVERLAY), "#%RAML 1.0 Overlay\nextends: <PATH_TO_RAML>");
        fragmentTemplates.put(new APIFragment(raml10, APIFragmentType.RESOURCE_TYPE), "#%RAML 1.0 ResourceType");
        fragmentTemplates.put(new APIFragment(raml10, APIFragmentType.SECURITY_SCHEME), "#%RAML 1.0 SecurityScheme\ntype: <SELECT_A_SECURITY_TYPE>");
        fragmentTemplates.put(new APIFragment(raml10, APIFragmentType.TRAIT), "#%RAML 1.0 Trait");
    }

    @Override
    public APITemplate create(APISpecification apiSpecification) {
        String templateText = specificationTemplates.get(apiSpecification);
        return templateText == null ? new EmptyAPITemplate() : new APITemplate(templateText);
    }

    @Override
    public APITemplate create(APIFragment apiFragment) {
        String templateText = fragmentTemplates.get(apiFragment);
        return templateText == null ? new EmptyAPITemplate() : new APITemplate(templateText);
    }
}

