/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.wizard.apis.core.template;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.mule.alsp.ALSPlugin;

public class APITemplate {
    private String template;

    public APITemplate(String template) {
        Objects.requireNonNull(template, "The template cannot be null");
        this.template = template;
    }

    public void writeTo(IFile file) {
        Objects.requireNonNull(file, "The destination file cannot be null");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayInputStream input = new ByteArrayInputStream(this.template.getBytes());){
                if (file.exists()) {
                    file.setContents((InputStream)input, 2, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    file.create((InputStream)input, true, null);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            ALSPlugin.logError("Couldn't write the template to file", e);
        }
    }

    public Writer writeTo(Writer writer) {
        Objects.requireNonNull(writer, "The writer cannot be null");
        try {
            writer.write(this.template);
        }
        catch (IOException e) {
            ALSPlugin.logError("Couldn't write the template to writer", e);
        }
        return writer;
    }
}

