/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.wizard.apis.core.model;

import java.util.Objects;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;

public class APISpecVersion {
    public static final APISpecVersion V_0_8_0 = new APISpecVersion(0, 8, 0);
    public static final APISpecVersion V_1_0_0 = new APISpecVersion(1, 0, 0);
    public static final APISpecVersion V_2_0_0 = new APISpecVersion(2, 0, 0);
    public static final APISpecVersion V_3_0_0 = new APISpecVersion(3, 0, 0);
    private byte major;
    private byte minor;
    private byte patch;

    private APISpecVersion(byte major, byte minor, byte patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static ILabelProvider asLabelProvider() {
        return LabelProvider.createTextProvider(i -> {
            APISpecVersion version = (APISpecVersion)i;
            return String.format("%s.%s", version.major, version.minor);
        });
    }

    public String toString() {
        return "APISpecVersion [" + this.major + "." + this.minor + "." + this.patch + "]";
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        APISpecVersion other = (APISpecVersion)obj;
        return this.major == other.major && this.minor == other.minor && this.patch == other.patch;
    }
}

