/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.validation;

import amf.apicontract.client.platform.AMFBaseUnitClient;
import amf.apicontract.client.platform.RAMLConfiguration;
import amf.apicontract.client.platform.model.document.DataType;
import amf.core.client.platform.AMFParseResult;
import amf.core.client.platform.model.document.BaseUnit;
import amf.core.client.platform.validation.AMFValidationReport;
import amf.core.client.scala.exception.UnsupportedVendorException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.mule.alsp.exception.IllegalCreationException;
import org.mule.alsp.validation.ValidationResult;

public class RAMLValidationUtils {
    private RAMLValidationUtils() {
        throw new IllegalCreationException();
    }

    public static boolean isRAML10DataType(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        try {
            AMFBaseUnitClient client = RAMLConfiguration.RAML10().baseUnitClient();
            AMFParseResult parseResult = (AMFParseResult)client.parseContent(text).get();
            BaseUnit result = parseResult.baseUnit();
            return result instanceof DataType;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    public static List<ValidationResult> validateRAML10DataType(String text) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        if (text == null || text.isEmpty()) {
            results.add(new ValidationResult("This RAML 1.0 is not a DataType"));
            return results;
        }
        try {
            AMFBaseUnitClient client = RAMLConfiguration.RAML10().baseUnitClient();
            AMFParseResult parseResult = (AMFParseResult)client.parseContent(text).get();
            BaseUnit result = parseResult.baseUnit();
            AMFValidationReport validationReport = (AMFValidationReport)client.validate(result).get();
            if (!(result instanceof DataType)) {
                results.add(new ValidationResult("This RAML 1.0 is not a DataType"));
            }
            if (!validationReport.conforms()) {
                results.addAll(RAMLValidationUtils.convertErrors(validationReport));
            }
        }
        catch (UnsupportedVendorException e) {
            results.add(new ValidationResult("Invalid RAML 1.0 DataType"));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            results.add(new ValidationResult("Could not validate as a RAML 1.0 DataType"));
        }
        catch (ExecutionException e) {
            results.add(new ValidationResult("Could not validate as a RAML 1.0 DataType"));
        }
        return results;
    }

    private static List<ValidationResult> convertErrors(AMFValidationReport validationReport) {
        return validationReport.results().stream().map(result -> new ValidationResult(result.message(), Math.max(0, result.position().start().line() - 1), result.position().start().column(), Math.max(0, result.position().end().line() - 1), result.position().end().column())).collect(Collectors.toList());
    }
}

