/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.ui.folding;

import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.AbstractReconciler;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.mule.alsp.ui.folding.IndentFoldingStrategy;

public class DefaultFoldingReconciler
extends AbstractReconciler {
    private final IndentFoldingStrategy foldingStrategy = new IndentFoldingStrategy();
    private static final Logger LOG = Logger.getLogger(DefaultFoldingReconciler.class.getName());

    public void install(ITextViewer textViewer) {
        super.install(textViewer);
        if (textViewer instanceof ProjectionViewer) {
            ProjectionViewer viewer = (ProjectionViewer)textViewer;
            this.foldingStrategy.setViewer(viewer);
        }
    }

    public void uninstall() {
        super.uninstall();
        if (this.foldingStrategy != null) {
            this.foldingStrategy.uninstall();
        }
    }

    protected void process(DirtyRegion dirtyRegion) {
        this.foldingStrategy.reconcile(dirtyRegion, null);
    }

    protected void reconcilerDocumentChanged(IDocument newDocument) {
        this.foldingStrategy.setDocument(newDocument);
    }

    public IReconcilingStrategy getReconcilingStrategy(String contentType) {
        return this.foldingStrategy;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        super.setProgressMonitor(monitor);
        this.foldingStrategy.setProgressMonitor(monitor);
    }

    protected void initialProcess() {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            LOG.warning("Interrupted during folding calculation");
            Thread.currentThread().interrupt();
        }
        super.initialProcess();
        this.foldingStrategy.initialReconcile();
    }
}

