/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.ui;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.mule.alsp.ALSPlugin;

public class APIEditorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String TEXT_EDITORS_LINK = "See <a>''{0}''</a> for general configuration";
    public static final String OVERRIDE_GENERAL_PREFERENCES_FOR_YAML_FILES = "apieditor.yaml.override_general_preferences";
    public static final String OVERRIDE_GENERAL_PREFERENCES_FOR_JSON_FILES = "apieditor.json.override_general_preferences";
    public static final String TAB_RATIO_FOR_YAML_FILES = "apieditor.yaml.tab_width";
    public static final String TAB_RATIO_FOR_JSON_FILES = "apieditor.json.tab_width";
    public static final String INSERT_SPACES_FOR_TABS_FOR_JSON_FILES = "apieditor.json.insert_spaces_for_tabs";
    private Group yamlGroup;
    private IntegerFieldEditor tabRatioForYamlFiles;
    private BooleanFieldEditor overwriteGeneralTextPreferencesForYamlFiles;
    private Group jsonGroup;
    private BooleanFieldEditor overwriteGeneralTextPreferencesForJsonFiles;
    private IntegerFieldEditor tabRatioForJsonFiles;
    private BooleanFieldEditor insertSpacesForTabs;

    public APIEditorPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(ALSPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        this.createLinkToGeneralPreferences();
        this.createYamlConfigurationGroup();
        this.createJsonConfigurationGroup();
    }

    protected void initialize() {
        super.initialize();
        this.enableOrDisableYamlConfiguration();
        this.enableOrDisableJsonConfiguration();
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getProperty().equals("field_editor_value") && event.getSource().equals(this.overwriteGeneralTextPreferencesForYamlFiles)) {
            this.enableOrDisableYamlConfiguration();
        } else if (event.getProperty().equals("field_editor_value") && event.getSource().equals(this.overwriteGeneralTextPreferencesForJsonFiles)) {
            this.enableOrDisableJsonConfiguration();
        }
    }

    private void createLinkToGeneralPreferences() {
        Composite linkAreaComposite = new Composite(this.getFieldEditorParent(), 32);
        new PreferenceLinkArea(linkAreaComposite, 32, "org.eclipse.ui.preferencePages.GeneralTextEditor", TEXT_EDITORS_LINK, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(2).generateLayout(linkAreaComposite);
        GridDataFactory.swtDefaults().align(4, 1).span(2, 1).grab(true, false).applyTo((Control)linkAreaComposite);
    }

    private void createYamlConfigurationGroup() {
        this.yamlGroup = new Group(this.getFieldEditorParent(), 32);
        this.yamlGroup.setText("YAML/RAML files");
        this.overwriteGeneralTextPreferencesForYamlFiles = new BooleanFieldEditor(OVERRIDE_GENERAL_PREFERENCES_FOR_YAML_FILES, "Override general text editor configuration", (Composite)this.yamlGroup);
        this.addField((FieldEditor)this.overwriteGeneralTextPreferencesForYamlFiles);
        this.tabRatioForYamlFiles = new IntegerFieldEditor(TAB_RATIO_FOR_YAML_FILES, "Displayed tab width", (Composite)this.yamlGroup){

            public void setEnabled(boolean enabled, Composite parent) {
                super.setEnabled(enabled, parent);
                APIEditorPreferencePage.this.enableCustomLabelText(this.getLabelControl(), enabled);
                this.refreshValidState();
            }
        };
        this.tabRatioForYamlFiles.setErrorMessage(NLS.bind((String)"Max number should be between 1 and {0}", (Object)16));
        this.tabRatioForYamlFiles.setValidateStrategy(0);
        this.tabRatioForYamlFiles.setValidRange(1, 16);
        this.addField((FieldEditor)this.tabRatioForYamlFiles);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(2).generateLayout((Composite)this.yamlGroup);
        GridDataFactory.swtDefaults().align(4, 1).span(2, 1).grab(true, false).applyTo((Control)this.yamlGroup);
    }

    private void createJsonConfigurationGroup() {
        this.jsonGroup = new Group(this.getFieldEditorParent(), 32);
        this.jsonGroup.setText("JSON files");
        this.overwriteGeneralTextPreferencesForJsonFiles = new BooleanFieldEditor(OVERRIDE_GENERAL_PREFERENCES_FOR_JSON_FILES, "Override general text editor configuration", (Composite)this.jsonGroup);
        this.addField((FieldEditor)this.overwriteGeneralTextPreferencesForJsonFiles);
        this.tabRatioForJsonFiles = new IntegerFieldEditor(TAB_RATIO_FOR_JSON_FILES, "Displayed tab width", (Composite)this.jsonGroup){

            public void setEnabled(boolean enabled, Composite parent) {
                super.setEnabled(enabled, parent);
                APIEditorPreferencePage.this.enableCustomLabelText(this.getLabelControl(), enabled);
                this.refreshValidState();
            }
        };
        this.tabRatioForJsonFiles.setErrorMessage(NLS.bind((String)"Max number should be between 1 and {0}", (Object)16));
        this.tabRatioForJsonFiles.setValidateStrategy(0);
        this.tabRatioForJsonFiles.setValidRange(1, 16);
        this.addField((FieldEditor)this.tabRatioForJsonFiles);
        this.insertSpacesForTabs = new BooleanFieldEditor(INSERT_SPACES_FOR_TABS_FOR_JSON_FILES, "Insert spaces for tabs", (Composite)this.jsonGroup);
        this.addField((FieldEditor)this.insertSpacesForTabs);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(2).generateLayout((Composite)this.jsonGroup);
        GridDataFactory.swtDefaults().align(4, 1).span(2, 1).grab(true, false).applyTo((Control)this.jsonGroup);
    }

    private void enableOrDisableYamlConfiguration() {
        this.tabRatioForYamlFiles.setEnabled(this.overwriteGeneralTextPreferencesForYamlFiles.getBooleanValue(), (Composite)this.yamlGroup);
    }

    private void enableOrDisableJsonConfiguration() {
        this.tabRatioForJsonFiles.setEnabled(this.overwriteGeneralTextPreferencesForJsonFiles.getBooleanValue(), (Composite)this.jsonGroup);
        this.insertSpacesForTabs.setEnabled(this.overwriteGeneralTextPreferencesForJsonFiles.getBooleanValue(), (Composite)this.jsonGroup);
    }

    private void enableCustomLabelText(Label label, boolean enabled) {
        label.setEnabled(enabled);
    }
}

