/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.telemetry;

import com.google.common.base.Enums;
import org.mule.alsp.telemetry.TelemetryStage;
import org.mule.alsp.telemetry.TelemetryType;

public enum TelemetryMessageTypes {
    BEGIN_PARSE,
    END_PARSE,
    BEGIN_PARSE_PATCHED,
    END_PARSE_PATCHED,
    BEGIN_REPORT,
    END_REPORT,
    BEGIN_PATCHING,
    END_PATCHING,
    GOT_DIAGNOSTICS,
    BEGIN_COMPLETION,
    END_COMPLETION,
    BEGIN_STRUCTURE,
    END_STRUCTURE,
    BEGIN_DIAGNOSTIC,
    END_DIAGNOSTIC,
    BEGIN_DIAGNOSTIC_PARSE,
    END_DIAGNOSTIC_PARSE,
    BEGIN_DIAGNOSTIC_RESOLVED,
    END_DIAGNOSTIC_RESOLVED,
    BEGIN_RESOLUTION,
    END_RESOLUTION,
    BEGIN_SERIALIZATION,
    END_SERIALIZATION,
    CHANGE_DOCUMENT,
    BEGIN_AMF_INIT,
    END_AMF_INIT,
    BEGIN_ALSP_COMPLETION,
    END_ALSP_COMPLETION,
    BEGIN_ALSP_DIAGNOSTCS,
    END_ALSP_DIAGNOSTCS,
    BEGIN_ALSP_STRUCTURE,
    END_ALSP_STRUCTURE,
    UNKNOWN;


    public TelemetryStage getStage() {
        return this.name().startsWith("BEGIN") ? TelemetryStage.BEGIN : TelemetryStage.END;
    }

    public TelemetryType getType() {
        String[] tokens = this.name().split("_", 2);
        if (tokens.length < 2) {
            return TelemetryType.UNKNOWN;
        }
        return (TelemetryType)((Object)Enums.getIfPresent(TelemetryType.class, (String)tokens[1]).or((Object)TelemetryType.UNKNOWN));
    }
}

