/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.telemetry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.mule.alsp.telemetry.ITelemetryEventProcessor;
import org.mule.alsp.telemetry.TelemetryEvent;
import org.mule.alsp.telemetry.TelemetryEventProducer;
import org.mule.alsp.telemetry.TelemetryMessageTypes;
import org.mule.alsp.telemetry.TelemetryStage;

public class TelemetryManager {
    private static final Logger LOG = Logger.getLogger(TelemetryManager.class.getName());
    public static final int MAX_ITEMS = 1000;
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private boolean telemetryEnabled = false;
    private final Map<String, Long> timings = new ConcurrentHashMap<String, Long>();
    private boolean timingsEnabled = false;
    private Map<String, TelemetryEvent> rawDataMap = new ConcurrentHashMap<String, TelemetryEvent>(1000);
    protected ITelemetryEventProcessor eventProcessor;
    private TelemetryEventProducer eventProducer;

    public TelemetryManager() {
        this(new ConcurrentHashMap<String, TelemetryEvent>(1000), event -> {
            LOG.fine(() -> String.format("%d ** %s ** %s ** %s ** %s", new Object[]{event.getTime(), event.getUri(), event.getMessageType().getType(), event.getMessageType().getStage(), event.getMessage()}));
            return true;
        });
    }

    public TelemetryManager(ITelemetryEventProcessor eventProcessor) {
        this(new ConcurrentHashMap<String, TelemetryEvent>(1000), eventProcessor);
    }

    public TelemetryManager(Map<String, TelemetryEvent> rawDataMap, ITelemetryEventProcessor eventProcessor) {
        this.rawDataMap = rawDataMap;
        this.eventProcessor = eventProcessor;
        this.eventProducer = new TelemetryEventProducer();
    }

    public void handleTelemetryMessage(Object jsonObject) {
        TelemetryEvent raw = (TelemetryEvent)gson.fromJson(gson.toJson(jsonObject), TelemetryEvent.class);
        if (raw != null) {
            if (raw.getMessageType() == null) {
                raw.setMessageType(TelemetryMessageTypes.UNKNOWN);
            }
            LOG.fine(() -> String.format("ALS telemetry message for %s : '%s' at %dms , event : %s, message : %s", raw.getUri(), raw.getMessageType().name(), raw.getTime(), raw.getMessage(), raw.getEvent()));
            this.addRawData(raw);
        }
    }

    public boolean addRawData(TelemetryEvent rawData) {
        if (rawData == null || rawData.getMessageType() == null || rawData.getTime() == null) {
            return false;
        }
        if (this.eventProcessor == null) {
            LOG.severe("Invalid TelemetryManager configuration");
            return false;
        }
        if (rawData.getMessageType().getStage() == TelemetryStage.BEGIN) {
            this.rawDataMap.put(rawData.key(), rawData);
            return true;
        }
        if (rawData.getMessageType().getStage() == TelemetryStage.END) {
            CompletableFuture<TelemetryEvent> future = CompletableFuture.supplyAsync(() -> this.eventProducer.process(rawData, this.rawDataMap));
            future.thenAcceptAsync(merged -> {
                if (merged != null) {
                    this.eventProcessor.process((TelemetryEvent)merged);
                }
            });
            return true;
        }
        return false;
    }

    public boolean isTelemetryEnabled() {
        return this.telemetryEnabled;
    }

    public void setTelemetryEnabled(boolean telemetryEnabled) {
        this.telemetryEnabled = telemetryEnabled;
    }

    public boolean isTimingsEnabled() {
        return this.timingsEnabled;
    }

    public void setTimingsEnabled(boolean timingsEnabled) {
        this.timingsEnabled = timingsEnabled;
    }

    public Map<String, Long> getTimings() {
        return this.timings;
    }
}

