/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.protocol.server;

import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.eclipse.ui.editors.text.EditorsUI;
import org.mule.alsp.ALSPlugin;
import org.mule.alsp.helpers.LSUtils;
import org.mule.alsp.protocol.ALSPTextDocumentService;
import org.mulesoft.als.server.lsp4j.LanguageServerImpl;
import org.mulesoft.als.server.lsp4j.extension.AlsClientCapabilities;
import org.mulesoft.als.server.lsp4j.extension.AlsFormattingOptions;
import org.mulesoft.als.server.lsp4j.extension.AlsInitializeParams;
import org.mulesoft.als.server.lsp4j.extension.AlsInitializeResult;
import org.mulesoft.als.server.lsp4j.extension.ExtendedLanguageServer;
import org.mulesoft.als.server.lsp4j.extension.SerializationClientCapabilities;
import org.mulesoft.als.server.lsp4j.extension.UpdateConfigurationParams;

public class ALSPLanguageServerWrapper
implements ExtendedLanguageServer {
    private static final String APPLICATION_RAML_YAML = "application/raml+yaml";
    private static final String APPLICATION_YAML = "application/yaml";
    private static final String APPLICATION_JSON = "application/json";
    private LanguageServerImpl server;

    public ALSPLanguageServerWrapper(LanguageServerImpl server) {
        this.server = server;
    }

    public CompletableFuture<AlsInitializeResult> initialize(AlsInitializeParams params) {
        this.fixRootUri(params);
        this.addSerializationCapability(params);
        this.addFormattingConfiguration(params);
        this.addFormattingPropertyListener(params);
        CompletableFuture future = this.server.initialize(params);
        if (future != null) {
            future.thenRunAsync(() -> ALSPlugin.getDefault().setAlsInitialized(true));
        }
        return future;
    }

    private void fixRootUri(AlsInitializeParams params) {
        String rootUri = params.getRootUri();
        if (LSUtils.isJarURI(rootUri)) {
            rootUri = LSUtils.findURIParent(rootUri);
            params.setRootUri(rootUri);
        }
    }

    private void addSerializationCapability(AlsInitializeParams alsParams) {
        if (alsParams.getCapabilities() != null) {
            alsParams.setCapabilities(alsParams.getCapabilities());
        } else {
            alsParams.setCapabilities(new AlsClientCapabilities());
        }
        alsParams.getCapabilities().setSerialization(new SerializationClientCapabilities(Boolean.TRUE));
    }

    private void addFormattingConfiguration(AlsInitializeParams alsParams) {
        HashMap<String, AlsFormattingOptions> formattingOptions = new HashMap<String, AlsFormattingOptions>();
        int tabReplacementRatioForYamlFiles = ALSPlugin.getDefault().getTabReplacementRatio();
        formattingOptions.put(APPLICATION_RAML_YAML, new AlsFormattingOptions(tabReplacementRatioForYamlFiles, true));
        formattingOptions.put(APPLICATION_YAML, new AlsFormattingOptions(tabReplacementRatioForYamlFiles, true));
        formattingOptions.put(APPLICATION_JSON, new AlsFormattingOptions(this.getTabReplacementRatioForJsonFiles(), this.getInsertSpacesForTabsForJsonFiles()));
        UpdateConfigurationParams updateParams = new UpdateConfigurationParams(formattingOptions, null);
        this.server.updateConfiguration(updateParams);
    }

    private void addFormattingPropertyListener(AlsInitializeParams alsParams) {
        ALSPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(event -> this.addFormattingConfiguration(alsParams));
        EditorsUI.getPreferenceStore().addPropertyChangeListener(event -> this.addFormattingConfiguration(alsParams));
    }

    private int getTabReplacementRatioForJsonFiles() {
        int customRatio;
        int ratio = EditorsUI.getPreferenceStore().getInt("tabWidth");
        IPreferenceStore store = ALSPlugin.getDefault().getPreferenceStore();
        if (store != null && store.getBoolean("apieditor.json.override_general_preferences") && (customRatio = store.getInt("apieditor.json.tab_width")) > 0) {
            ratio = customRatio;
        }
        return ratio;
    }

    private boolean getInsertSpacesForTabsForJsonFiles() {
        boolean insertSpacesForTabs = EditorsUI.getPreferenceStore().getBoolean("spacesForTabs");
        IPreferenceStore store = ALSPlugin.getDefault().getPreferenceStore();
        if (store != null && store.getBoolean("apieditor.json.override_general_preferences")) {
            insertSpacesForTabs = store.getBoolean("apieditor.json.insert_spaces_for_tabs");
        }
        return insertSpacesForTabs;
    }

    public void initialized(InitializedParams params) {
        this.server.initialized(params);
    }

    public void initialized() {
        this.server.initialized(null);
    }

    public CompletableFuture<Object> shutdown() {
        ALSPlugin.getDefault().setAlsInitialized(false);
        return this.server.shutdown();
    }

    public void exit() {
        ALSPlugin.getDefault().setAlsInitialized(false);
        this.server.exit();
    }

    public TextDocumentService getTextDocumentService() {
        return new ALSPTextDocumentService((TextDocumentService)this.server.getTextDocumentService());
    }

    public WorkspaceService getWorkspaceService() {
        return this.server.getWorkspaceService();
    }

    public void updateConfiguration(UpdateConfigurationParams params) {
        this.server.updateConfiguration(params);
    }
}

