/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.protocol.client;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.services.LanguageClient;
import org.mule.alsp.helpers.LSUtils;
import org.mulesoft.lsp.feature.telemetry.TelemetryMessage;

public class ALSPLanguageClientDecorator
implements LanguageClient {
    private static final Logger LOG = Logger.getLogger(ALSPLanguageClientDecorator.class.getName());
    private LanguageClient client;

    public ALSPLanguageClientDecorator(LanguageClient client) {
        this.client = client;
    }

    public CompletableFuture<List<Object>> configuration(ConfigurationParams configurationParams) {
        return this.client.configuration(configurationParams);
    }

    public CompletableFuture<Void> registerCapability(RegistrationParams params) {
        return this.client.registerCapability(params);
    }

    public CompletableFuture<List<WorkspaceFolder>> workspaceFolders() {
        return this.client.workspaceFolders();
    }

    public CompletableFuture<Void> unregisterCapability(UnregistrationParams params) {
        return this.client.unregisterCapability(params);
    }

    public void telemetryEvent(Object object) {
        if (!(object instanceof TelemetryMessage)) {
            return;
        }
        TelemetryMessage orig = (TelemetryMessage)object;
        String uri = LSUtils.fixURI(orig.uri());
        TelemetryMessage telMsg = orig.copy(orig.event(), orig.messageType(), orig.message(), uri, orig.time(), orig.uuid());
        this.client.telemetryEvent((Object)telMsg);
    }

    public void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
        if (LSUtils.isJarURI(diagnostics.getUri())) {
            diagnostics.setUri("");
        }
        this.client.publishDiagnostics(diagnostics);
    }

    public void showMessage(MessageParams messageParams) {
        if (messageParams != null && messageParams.getType() != null) {
            LOG.fine(() -> String.format("ALSPLanguageClientDecorator - showMessage - %s", messageParams.getType().name()));
            this.client.showMessage(messageParams);
        }
    }

    public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams requestParams) {
        return this.client.showMessageRequest(requestParams);
    }

    public void logMessage(MessageParams message) {
        this.client.logMessage(message);
    }
}

