/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.protocol.client;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.UUID;
import org.eclipse.lsp4e.LanguageClientImpl;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.Registration;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.genericeditor.ExtensionBasedTextEditor;
import org.mule.alsp.ALSPlugin;
import org.mule.alsp.editor.ActiveEditorListener;
import org.mule.alsp.telemetry.TelemetryManager;

public class ALSLanguageClient
extends LanguageClientImpl {
    private static final String WORKSPACE_EXECUTE_COMMAND = "workspace/executeCommand";
    private Registration registration;
    private TelemetryManager telemetryManager;

    public ALSLanguageClient() {
        this(new TelemetryManager());
    }

    public ALSLanguageClient(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
        this.init();
    }

    public void init() {
        try {
            UUID id = this.getUUID();
            this.registerCommands(id, "didFocusChange");
            this.startListener();
        }
        catch (Exception e) {
            ALSPlugin.logError(e);
        }
    }

    public void registerCommands(UUID id, String ... command) {
        this.registration = new Registration();
        this.registration.setId(id.toString());
        this.registration.setMethod(WORKSPACE_EXECUTE_COMMAND);
        ExecuteCommandOptions commandOptions = new ExecuteCommandOptions(Arrays.asList(command));
        this.registration.setRegisterOptions((Object)new Gson().toJsonTree((Object)commandOptions));
        this.registerCapability(new RegistrationParams(Arrays.asList(this.registration)));
    }

    public void startListener() {
        IWorkbenchWindow[] windows = this.getWindows();
        if (windows == null) {
            return;
        }
        this.addListeners(windows);
    }

    public void addListeners(IWorkbenchWindow[] windows) {
        IWorkbenchWindow[] iWorkbenchWindowArray = windows;
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            if (window.getActivePage() != null && window.getActivePage().getActiveEditor() instanceof ExtensionBasedTextEditor) {
                window.getActivePage().addPartListener((IPartListener2)new ActiveEditorListener());
            } else if (window.getActivePage() != null) {
                IEditorReference[] iEditorReferenceArray = window.getActivePage().getEditorReferences();
                int n3 = iEditorReferenceArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IEditorReference ep = iEditorReferenceArray[n4];
                    if (ep.getPart(false) instanceof ExtensionBasedTextEditor) {
                        window.getActivePage().addPartListener((IPartListener2)new ActiveEditorListener());
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public Registration getRegistration() {
        return this.registration;
    }

    public void setRegistration(Registration registration) {
        this.registration = registration;
    }

    public UUID getUUID() {
        return UUID.randomUUID();
    }

    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public IWorkbenchWindow[] getWindows() {
        return this.getWorkbench().getWorkbenchWindows();
    }

    public void telemetryEvent(Object jsonObject) {
        if (ALSPlugin.isALSTelemetryEnabled() && this.telemetryManager != null) {
            this.telemetryManager.handleTelemetryMessage(jsonObject);
        }
    }
}

