/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.protocol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.mule.alsp.protocol.TextDocumentServiceInterceptor;

public class TextDocumentServicePostprocessor {
    private final Map<String, List<TextDocumentServiceInterceptor<?, ?>>> interceptors = new HashMap();

    public <K, T> void addInterceptor(TextDocumentServiceInterceptor<K, T> interceptor) {
        if (!this.interceptors.containsKey(interceptor.getMethodName())) {
            this.interceptors.put(interceptor.getMethodName(), new ArrayList());
        }
        this.interceptors.get(interceptor.getMethodName()).add(interceptor);
    }

    public <K, T> CompletableFuture<T> process(String methodName, K methodArgument, CompletableFuture<T> future) {
        if (future == null) {
            return null;
        }
        List<TextDocumentServiceInterceptor<?, ?>> processors = this.interceptors.get(methodName);
        for (TextDocumentServiceInterceptor<?, ?> processor : processors) {
            future = future.thenApply(f -> processor.intercept(methodArgument, f));
        }
        return future;
    }
}

