/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.protocol;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.InsertReplaceEdit;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.mule.alsp.ALSPlugin;
import org.mule.alsp.format.IndentInformation;
import org.mule.alsp.format.SourceFormatter;
import org.mule.alsp.helpers.LSUtils;
import org.mule.alsp.protocol.TextDocumentServiceInterceptor;

public class JSONIndentationFixInterceptor
implements TextDocumentServiceInterceptor<CompletionParams, Either<List<CompletionItem>, CompletionList>> {
    @Override
    public String getMethodName() {
        return "completion";
    }

    @Override
    public Either<List<CompletionItem>, CompletionList> intercept(CompletionParams methodArgument, Either<List<CompletionItem>, CompletionList> either) {
        List items;
        if (either == null) {
            return null;
        }
        List list = items = either.isLeft() ? (List)either.getLeft() : ((CompletionList)either.getRight()).getItems();
        if (items == null || items.isEmpty()) {
            return either;
        }
        if (methodArgument == null || methodArgument.getTextDocument() == null || StringUtils.isBlank((CharSequence)methodArgument.getTextDocument().getUri())) {
            throw new IllegalArgumentException("methodArgument is invalid");
        }
        IDocument currentDocument = LSUtils.getCurrentDocument(methodArgument);
        if (currentDocument == null || currentDocument.get().isEmpty() || !LSUtils.isJsonDocument(methodArgument, currentDocument)) {
            return either;
        }
        try {
            IndentInformation firstLine = SourceFormatter.getFirstLineIndentInformation((TextDocumentPositionParams)methodArgument, currentDocument);
            for (CompletionItem completionItem : items) {
                StringBuilder builder;
                String text;
                Either textEditEither = completionItem.getTextEdit();
                if (textEditEither.isLeft()) {
                    text = ((TextEdit)textEditEither.getLeft()).getNewText();
                    builder = SourceFormatter.fixTextIndent(text, firstLine);
                    ((TextEdit)textEditEither.getLeft()).setNewText(builder.toString());
                    completionItem.setFilterText(builder.toString());
                    continue;
                }
                text = ((InsertReplaceEdit)textEditEither.getRight()).getNewText();
                builder = SourceFormatter.fixTextIndent(text, firstLine);
                ((InsertReplaceEdit)textEditEither.getRight()).setNewText(builder.toString());
                completionItem.setFilterText(builder.toString());
            }
        }
        catch (BadLocationException e) {
            ALSPlugin.logError(e);
        }
        return either;
    }
}

