/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.protocol;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.ColorPresentation;
import org.eclipse.lsp4j.ColorPresentationParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DeclarationParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentColorParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentLinkParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.ImplementationParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.PrepareRenameDefaultBehavior;
import org.eclipse.lsp4j.PrepareRenameParams;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.TypeDefinitionParams;
import org.eclipse.lsp4j.TypeHierarchyItem;
import org.eclipse.lsp4j.TypeHierarchyPrepareParams;
import org.eclipse.lsp4j.TypeHierarchySubtypesParams;
import org.eclipse.lsp4j.TypeHierarchySupertypesParams;
import org.eclipse.lsp4j.WillSaveTextDocumentParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Either3;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.mule.alsp.helpers.LSUtils;
import org.mule.alsp.protocol.ALSPContentAssistDocumentationRemover;
import org.mule.alsp.protocol.ALSPContentAssistLabelDecorator;
import org.mule.alsp.protocol.IndentationFixInterceptor;
import org.mule.alsp.protocol.JSONIndentationFixInterceptor;
import org.mule.alsp.protocol.TextDocumentServicePostprocessor;

public class ALSPTextDocumentService
implements TextDocumentService {
    private TextDocumentService tds;
    private TextDocumentServicePostprocessor postProcessor;

    public ALSPTextDocumentService(TextDocumentService tds) {
        this.tds = tds;
        this.postProcessor = new TextDocumentServicePostprocessor();
        this.postProcessor.addInterceptor(new ALSPContentAssistDocumentationRemover());
        this.postProcessor.addInterceptor(new ALSPContentAssistLabelDecorator());
        this.postProcessor.addInterceptor(new JSONIndentationFixInterceptor());
        this.postProcessor.addInterceptor(new IndentationFixInterceptor());
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams position) {
        LSUtils.fixParams(position);
        CompletableFuture<Either<List<CompletionItem>, CompletionList>> completionFuture = this.tds.completion(position);
        completionFuture = this.postProcessor.process("completion", position, completionFuture);
        return completionFuture;
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        return this.tds.resolveCompletionItem(unresolved);
    }

    public CompletableFuture<Hover> hover(HoverParams position) {
        LSUtils.fixParams(position);
        return this.tds.hover(position);
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> declaration(DeclarationParams params) {
        LSUtils.fixParams(params);
        return this.tds.declaration(params);
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams position) {
        LSUtils.fixParams(position);
        return this.tds.definition(position);
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> typeDefinition(TypeDefinitionParams position) {
        LSUtils.fixParams(position);
        return this.tds.typeDefinition(position);
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> implementation(ImplementationParams position) {
        LSUtils.fixParams(position);
        return this.tds.implementation(position);
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        LSUtils.fixParams(params);
        return this.tds.references(params);
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(DocumentHighlightParams position) {
        LSUtils.fixParams(position);
        return this.tds.documentHighlight(position);
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        LSUtils.fixParams(params);
        return this.tds.documentSymbol(params);
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        LSUtils.fixParams(params);
        return this.tds.codeAction(params);
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        LSUtils.fixParams(params);
        return this.tds.codeLens(params);
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        LSUtils.fixParams(unresolved);
        return this.tds.resolveCodeLens(unresolved);
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        LSUtils.fixParams(params);
        return this.tds.formatting(params);
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        LSUtils.fixParams(params);
        return this.tds.rangeFormatting(params);
    }

    public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams params) {
        LSUtils.fixParams(params);
        return this.tds.onTypeFormatting(params);
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        LSUtils.fixParams(params);
        return this.tds.rename(params);
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        LSUtils.fixParams(params);
        this.tds.didOpen(params);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        LSUtils.fixParams(params);
        this.tds.didChange(params);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        LSUtils.fixParams(params);
        this.tds.didClose(params);
    }

    public void didSave(DidSaveTextDocumentParams params) {
        LSUtils.fixParams(params);
        this.tds.didSave(params);
    }

    public void willSave(WillSaveTextDocumentParams params) {
        LSUtils.fixParams(params);
        this.tds.willSave(params);
    }

    public CompletableFuture<List<TextEdit>> willSaveWaitUntil(WillSaveTextDocumentParams params) {
        LSUtils.fixParams(params);
        return this.tds.willSaveWaitUntil(params);
    }

    public CompletableFuture<List<DocumentLink>> documentLink(DocumentLinkParams params) {
        LSUtils.fixParams(params);
        CompletableFuture future = this.tds.documentLink(params);
        future.thenApply(dl -> {
            for (DocumentLink documentLink : dl) {
                String uriTarget = LSUtils.fixURI(documentLink.getTarget());
                documentLink.setTarget(uriTarget);
            }
            return dl;
        });
        return future;
    }

    public CompletableFuture<DocumentLink> documentLinkResolve(DocumentLink params) {
        LSUtils.fixParams(params);
        CompletableFuture future = this.tds.documentLinkResolve(params);
        future.thenApply(dl -> {
            String uriTarget = LSUtils.fixURI(dl.getTarget());
            dl.setTarget(uriTarget);
            return dl;
        });
        return future;
    }

    public CompletableFuture<List<ColorInformation>> documentColor(DocumentColorParams params) {
        LSUtils.fixParams(params);
        return this.tds.documentColor(params);
    }

    public CompletableFuture<List<ColorPresentation>> colorPresentation(ColorPresentationParams params) {
        LSUtils.fixParams(params);
        return this.tds.colorPresentation(params);
    }

    public CompletableFuture<List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        LSUtils.fixParams(params);
        return this.tds.foldingRange(params);
    }

    public CompletableFuture<Either3<Range, PrepareRenameResult, PrepareRenameDefaultBehavior>> prepareRename(PrepareRenameParams params) {
        LSUtils.fixParams(params);
        return this.tds.prepareRename(params);
    }

    public CompletableFuture<List<TypeHierarchyItem>> typeHierarchySubtypes(TypeHierarchySubtypesParams params) {
        LSUtils.fixParams(params);
        return this.tds.typeHierarchySubtypes(params);
    }

    public CompletableFuture<List<TypeHierarchyItem>> typeHierarchySupertypes(TypeHierarchySupertypesParams params) {
        LSUtils.fixParams(params);
        return this.tds.typeHierarchySupertypes(params);
    }

    public CompletableFuture<List<TypeHierarchyItem>> prepareTypeHierarchy(TypeHierarchyPrepareParams params) {
        LSUtils.fixParams(params);
        return this.tds.prepareTypeHierarchy(params);
    }
}

