/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.helpers;

import amf.core.internal.remote.JvmPlatform;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.VirtualFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TypeHierarchyItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.texteditor.ITextEditor;
import org.mule.alsp.ALSPlugin;
import org.mule.alsp.SupportedContentTypes;

public class LSUtils {
    private static final Logger LOG = Logger.getLogger(LSUtils.class.getName());
    private static final String JAR_SCHEME_FORMAT = "jar:%s!/%s";
    private static final String JAR_FILE_PREFIX = "jar:file:/";
    private static final String JAR_PREFIX = "jar:/";
    private static final String GET_TEXT_DOCUMENT = "getTextDocument";
    private static final String GET_ITEM = "getItem";
    public static final String FILE_URL_PREFIX = "file://";
    public static final String NEWLINE_LF = "\n";
    public static final String NEWLINE_CRLF = "\r\n";
    public static final char SPACE = ' ';
    public static final char TAB = '\t';
    public static final String TAB_STRING = "\t";
    public static final String JSON_EXTENSION = ".json";
    public static final String SPACE_ESCAPE = "%20";
    public static final String SLASH = "/";
    public static final String WHITESPACE_REGEXP = "\\s";

    private LSUtils() {
    }

    public static URI fixURI(URI uri) {
        return URI.create(LSUtils.fixURI(uri.toString()));
    }

    public static boolean isJarURI(URI uri) {
        return LSUtils.isJarURI(uri.toString());
    }

    public static boolean isJarURI(String uriPath) {
        return !StringUtils.isBlank((CharSequence)uriPath) && (uriPath.contains(".zip!/") || uriPath.contains(".jar!/"));
    }

    public static String fixURI(String uriPath) {
        String newUri = uriPath;
        if (LSUtils.isJarURI(newUri)) {
            if (newUri.contains(JAR_FILE_PREFIX)) {
                newUri = newUri.substring(newUri.lastIndexOf(JAR_FILE_PREFIX));
            }
            if (newUri.contains(JAR_PREFIX)) {
                newUri = newUri.substring(newUri.lastIndexOf(JAR_PREFIX));
            }
            newUri = newUri.replaceFirst("^file://jar:", "jar:");
            newUri = newUri.replaceFirst("^file:/", JAR_FILE_PREFIX);
            newUri = newUri.replaceFirst("^jar:/", JAR_FILE_PREFIX);
        }
        return newUri;
    }

    public static String findURIParent(String uriPath) {
        String newUri = LSUtils.fixURI(uriPath);
        newUri = newUri.substring(0, newUri.lastIndexOf(47) + 1);
        return newUri;
    }

    public static String getNameInArchive(URI uri) {
        return uri == null ? null : LSUtils.getNameInArchive(uri.toString());
    }

    public static String getNameInArchive(String uri) {
        return uri == null || !LSUtils.isJarURI(uri) ? null : uri.substring(1 + uri.lastIndexOf(47));
    }

    public static void fixParams(Object params) {
        Method m;
        try {
            m = params.getClass().getMethod(GET_TEXT_DOCUMENT, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                m = params.getClass().getMethod(GET_ITEM, new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                return;
            }
        }
        try {
            if (TextDocumentIdentifier.class.isAssignableFrom(m.getReturnType())) {
                TextDocumentIdentifier documentId = (TextDocumentIdentifier)m.invoke(params, new Object[0]);
                LSUtils.fixParams(documentId);
            } else if (TextDocumentItem.class.isAssignableFrom(m.getReturnType())) {
                TextDocumentItem result = (TextDocumentItem)m.invoke(params, new Object[0]);
                result.setUri(LSUtils.fixURI(result.getUri()));
            } else if (TypeHierarchyItem.class.isAssignableFrom(m.getReturnType())) {
                TypeHierarchyItem result = (TypeHierarchyItem)m.invoke(params, new Object[0]);
                result.setUri(LSUtils.fixURI(result.getUri()));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            LOG.severe(e.getMessage());
        }
    }

    public static void fixParams(PublishDiagnosticsParams params) {
        params.setUri(LSUtils.fixURI(params.getUri()));
    }

    public static void fixParams(DocumentLink params) {
        params.setTarget(LSUtils.fixURI(params.getTarget()));
    }

    public static URI createArchiveURI(String pathToArchive, String pathToItem, boolean shortSchemePrefix) {
        String pathToItemNormalized = pathToItem;
        if (pathToItem.startsWith(SLASH)) {
            pathToItemNormalized = pathToItem.replaceFirst(SLASH, "");
        }
        String uriString = LSUtils.fixURI(String.format(JAR_SCHEME_FORMAT, new File(pathToArchive).toURI().toString(), pathToItemNormalized));
        if (shortSchemePrefix) {
            uriString = uriString.replaceFirst(JAR_FILE_PREFIX, JAR_PREFIX);
        }
        return URI.create(uriString.replaceAll(WHITESPACE_REGEXP, SPACE_ESCAPE));
    }

    public static void fixParams(TextDocumentIdentifier documentId) {
        documentId.setUri(LSUtils.fixURI(documentId.getUri()));
    }

    public static IPath getResourcePathFromString(String path) {
        return Path.fromOSString((String)JvmPlatform.instance().decodeURI(path.replaceFirst(FILE_URL_PREFIX, "")));
    }

    public static String getLine(IDocument document, int lineNum) throws BadLocationException {
        if (document == null || lineNum < 0) {
            return null;
        }
        int offsetAtStart = document.getLineOffset(lineNum);
        int lineLength = document.getLineLength(lineNum);
        return document.get(offsetAtStart, lineLength);
    }

    public static IDocument getCurrentDocument(ITextEditor textEditor) {
        IDocument currentDocument = LSPEclipseUtils.getDocument((ITextEditor)textEditor);
        if (currentDocument == null) {
            currentDocument = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        }
        return currentDocument;
    }

    public static SupportedContentTypes getContentType(IDocument currentDocument, ITextEditor textEditor) {
        int extensionOffset;
        List contentTypes = null;
        try {
            ResourcesPlugin.getWorkspace();
            contentTypes = LSPEclipseUtils.getDocumentContentTypes((IDocument)currentDocument);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (contentTypes != null) {
            SupportedContentTypes supported = null;
            supported = contentTypes.stream().map(c -> SupportedContentTypes.fromContentTypeId(c.getId())).filter(sct -> sct != SupportedContentTypes.UNSUPPORTED).findFirst().orElse(SupportedContentTypes.UNSUPPORTED);
            if (!supported.equals((Object)SupportedContentTypes.UNSUPPORTED)) {
                return supported;
            }
        }
        if ((extensionOffset = textEditor.getEditorInput().getName().lastIndexOf(46)) < 0) {
            return SupportedContentTypes.UNSUPPORTED;
        }
        String extension = textEditor.getEditorInput().getName().substring(extensionOffset);
        return SupportedContentTypes.fromExtension(extension);
    }

    public static int getCurrentCursorOffset(ExecutionEvent event) {
        Event swtEvent = (Event)event.getTrigger();
        if (swtEvent == null) {
            return -1;
        }
        StyledText styleText = (StyledText)swtEvent.widget;
        if (styleText == null) {
            return -1;
        }
        return styleText.getCaretOffset();
    }

    public static boolean isJsonDocument(CompletionParams methodArgument, IDocument currentDocument) {
        List ct = null;
        try {
            ResourcesPlugin.getWorkspace();
            ct = LSPEclipseUtils.getDocumentContentTypes((IDocument)currentDocument);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (ct != null && ct.size() == 1 && "org.apieditor.sjson".equals(((IContentType)ct.get(0)).getId())) {
            return true;
        }
        return (ct == null || ct.size() != 1) && methodArgument.getTextDocument().getUri().endsWith(JSON_EXTENSION);
    }

    public static IDocument getCurrentDocument(CompletionParams methodArgument) {
        Path path;
        ITextFileBufferManager textFileBufferManager;
        ITextFileBuffer textFileBuffer;
        IDocument currentDocument = null;
        try {
            currentDocument = LSPEclipseUtils.getDocument((IResource)LSPEclipseUtils.findResourceFor((String)methodArgument.getTextDocument().getUri()));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (currentDocument == null) {
            try {
                File file = new File(new URI(methodArgument.getTextDocument().getUri()));
                if (file.exists()) {
                    currentDocument = new Document(FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset()));
                }
            }
            catch (IOException | URISyntaxException e) {
                ALSPlugin.logError(e);
            }
        }
        if (currentDocument == null && (textFileBuffer = (textFileBufferManager = ITextFileBufferManager.DEFAULT).getTextFileBuffer((IPath)(path = new Path(methodArgument.getTextDocument().getUri())), LocationKind.LOCATION)) != null) {
            currentDocument = textFileBuffer.getDocument();
        }
        if (currentDocument == null) {
            try {
                VirtualFileStore fileStore = new VirtualFileStore(new URI(methodArgument.getTextDocument().getUri()));
                textFileBufferManager = ITextFileBufferManager.DEFAULT;
                textFileBuffer = textFileBufferManager.getFileStoreTextFileBuffer((IFileStore)fileStore);
                if (textFileBuffer != null) {
                    currentDocument = textFileBuffer.getDocument();
                }
            }
            catch (URISyntaxException e) {
                ALSPlugin.logError(e);
            }
        }
        return currentDocument;
    }
}

