/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.mule.alsp.SupportedContentTypes;
import org.mule.alsp.editor.ActiveEditorListener;
import org.mule.alsp.format.JSONUnindentAction;
import org.mule.alsp.format.UnindentAction;
import org.mule.alsp.format.YAMLUnindentAction;
import org.mule.alsp.helpers.LSUtils;

public class UnindentHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        int cursorOffset;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof TextSelection)) {
            return null;
        }
        ITextEditor textEditor = ActiveEditorListener.getActiveTextEditor();
        if (textEditor == null) {
            return null;
        }
        IDocument document = LSUtils.getCurrentDocument(textEditor);
        if (document == null) {
            return null;
        }
        TextSelection ts = (TextSelection)selection;
        if (ts.getLength() == 0 && (cursorOffset = LSUtils.getCurrentCursorOffset(event)) >= 0) {
            ts = new TextSelection(document, cursorOffset, 0);
        }
        SupportedContentTypes contentType = LSUtils.getContentType(document, textEditor);
        UnindentAction action = null;
        switch (contentType) {
            case JSON: {
                action = new JSONUnindentAction();
                break;
            }
            case RAML: 
            case YAML: {
                action = new YAMLUnindentAction();
                break;
            }
            default: {
                return null;
            }
        }
        action.execute(document, ts);
        return null;
    }
}

