/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.format;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.mule.alsp.ALSPlugin;
import org.mule.alsp.format.IndentInformation;
import org.mule.alsp.helpers.LSUtils;

public abstract class UnindentAction {
    public void execute(IDocument document, TextSelection selection) {
        int startLine = selection.getStartLine();
        int endLine = selection.getEndLine();
        try {
            int lineNum = startLine;
            while (lineNum <= endLine) {
                String lineText = LSUtils.getLine(document, lineNum);
                this.processLine(document.getLineOffset(lineNum), new IndentInformation(lineText), document);
                ++lineNum;
            }
        }
        catch (BadLocationException ex) {
            ALSPlugin.logError(ex);
        }
    }

    protected abstract void processLine(int var1, IndentInformation var2, IDocument var3) throws BadLocationException;
}

