/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.format;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.mule.alsp.ALSPlugin;
import org.mule.alsp.format.IndentInformation;

public class SourceFormatter {
    private static final int SPACE_TO_TAB_RATIO = 2;

    private SourceFormatter() {
    }

    public static IndentInformation getFirstLineIndentInformation(TextDocumentPositionParams methodArgument, IDocument currentDocument) throws BadLocationException {
        IRegion lineInformation = currentDocument.getLineInformation(methodArgument.getPosition().getLine());
        IndentInformation firstLine = new IndentInformation(currentDocument.get(lineInformation.getOffset(), lineInformation.getLength()), methodArgument.getPosition().getCharacter());
        firstLine.setNewLine(currentDocument.getLineDelimiter(methodArgument.getPosition().getLine()));
        return firstLine;
    }

    public static StringBuilder fixTextIndent(String text, IndentInformation firstLine) {
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new StringReader(text));
        List lines = reader.lines().collect(Collectors.toList());
        Iterator iterator = lines.iterator();
        while (iterator.hasNext()) {
            String line = (String)iterator.next();
            if (line.charAt(0) == ' ' && firstLine.getIndentChar() == '\t') {
                int i = 0;
                while (line.charAt(i) == ' ') {
                    ++i;
                }
                int newIndentCount = Math.max(0, i - firstLine.getNumberOfIndentChars()) / 2;
                String newIndent = "";
                if (newIndentCount > 0) {
                    newIndent = StringUtils.repeat((char)firstLine.getIndentChar(), (int)newIndentCount);
                }
                builder.append(firstLine.getIndent() + newIndent);
                builder.append(line.substring(i));
            } else {
                builder.append(line);
            }
            if (!iterator.hasNext()) continue;
            builder.append(firstLine.getNewLine() + firstLine.getIndent());
        }
        return builder;
    }

    public static String fixCompletionTextIndent(String text, IndentInformation firstLine) {
        String newLine = SourceFormatter.getNewLineUsed(text);
        if (newLine != null) {
            return text.replaceAll(newLine, newLine + firstLine.getIndent());
        }
        return text;
    }

    public static String fixNewLineEnding(String line) {
        String newLine = null;
        if (line.endsWith("\r\n")) {
            newLine = "\r\n";
        } else if (line.endsWith("\n")) {
            newLine = "\n";
        }
        return newLine;
    }

    public static String getNewLineUsed(String text) {
        if (text.contains("\r\n")) {
            return "\r\n";
        }
        if (text.contains("\n")) {
            return "\n";
        }
        return null;
    }

    public static String convertIndentToSpaces(String line, int tabToSpaceRatio) {
        if (line == null) {
            return "";
        }
        int countSpaces = 0;
        int i = 0;
        while (i < line.length()) {
            if (line.charAt(i) == ' ') {
                ++countSpaces;
            } else {
                if (line.charAt(i) != '\t') break;
                countSpaces += tabToSpaceRatio;
            }
            ++i;
        }
        return StringUtils.repeat((char)' ', (int)countSpaces);
    }

    public static String replaceTabCharacter(String text) {
        return text.replace("\t", StringUtils.repeat((char)' ', (int)ALSPlugin.getDefault().getTabReplacementRatio()));
    }

    public static void unindentDocumentText(int offset, int numberOfIndentChars, IDocument document) throws BadLocationException {
        int charsToReplace = Math.min(numberOfIndentChars, ALSPlugin.getDefault().getTabReplacementRatio());
        if (charsToReplace > 0) {
            document.replace(offset, charsToReplace, "");
        }
    }
}

