/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.format;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4j.Position;
import org.mule.alsp.ALSPlugin;
import org.mule.alsp.SupportedContentTypes;
import org.mule.alsp.editor.ActiveEditorListener;
import org.mule.alsp.format.IndentInformation;
import org.mule.alsp.format.SourceFormatter;
import org.mule.alsp.helpers.LSUtils;

public class NewLineAutoEdit
implements IAutoEditStrategy {
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        try {
            if (document == null || command == null || command.text == null) {
                return;
            }
            if (!command.text.contentEquals("\r\n") && !command.text.contentEquals("\n")) {
                return;
            }
            Position position = LSPEclipseUtils.toPosition((int)command.offset, (IDocument)document);
            IndentInformation indentInfo = new IndentInformation(LSUtils.getLine(document, position.getLine()), position.getCharacter());
            SupportedContentTypes contentType = LSUtils.getContentType(document, ActiveEditorListener.getActiveTextEditor());
            String indent = null;
            indent = contentType == SupportedContentTypes.JSON ? indentInfo.getIndent() : SourceFormatter.convertIndentToSpaces(indentInfo.getLine(), ALSPlugin.getDefault().getTabReplacementRatio());
            command.text = command.text + indent;
        }
        catch (BadLocationException e) {
            ALSPlugin.logError(e);
        }
    }
}

