/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.format;

import org.mule.alsp.format.SourceFormatter;

public class IndentInformation {
    private String line;
    private String indent = "";
    private int numberOfIndentChars;
    private char indentChar;
    private String newLine;

    public IndentInformation(String line, int lengthLineLimit) {
        this.initialize(line, lengthLineLimit);
    }

    public IndentInformation(String line) {
        this.initialize(line, Integer.MAX_VALUE);
    }

    public String getLine() {
        return this.line;
    }

    public String getIndent() {
        return this.indent;
    }

    public int getNumberOfIndentChars() {
        return this.numberOfIndentChars;
    }

    public char getIndentChar() {
        return this.indentChar;
    }

    public String getNewLine() {
        return this.newLine;
    }

    public void setNewLine(String newLine) {
        this.newLine = newLine;
    }

    private void initialize(String lineToInit, int completionPosition) {
        this.line = lineToInit;
        if (this.line == null) {
            return;
        }
        if (this.line.isEmpty()) {
            this.indentChar = (char)9;
        } else if (this.line.charAt(0) == ' ' || this.line.charAt(0) == '\t') {
            this.indentChar = this.line.charAt(0);
        }
        int i = 0;
        while (i < Math.min(this.line.length(), completionPosition)) {
            if (this.line.charAt(i) != ' ' && this.line.charAt(i) != '\t') break;
            ++this.numberOfIndentChars;
            ++i;
        }
        this.indent = this.line.substring(0, i);
        this.newLine = SourceFormatter.fixNewLineEnding(this.line);
    }
}

