/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.filesystem;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.logging.Logger;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.resources.VirtualFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.mule.alsp.helpers.LSUtils;

public class JarFileStore
extends VirtualFileStore {
    private static final Logger LOG = Logger.getLogger(JarFileStore.class.getName());

    public JarFileStore(URI location) {
        super(location);
    }

    public String getName() {
        return LSUtils.getNameInArchive(this.toURI());
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) {
        if (this.toURI() == null) {
            return null;
        }
        try {
            return LSUtils.fixURI(this.toURI()).toURL().openStream();
        }
        catch (IOException e) {
            LOG.severe(e.getMessage());
            return null;
        }
    }

    public File toLocalFile(int options, IProgressMonitor monitor) throws CoreException {
        return null;
    }

    public IFileInfo fetchInfo() {
        FileInfo result = new FileInfo();
        result.setDirectory(false);
        result.setExists(true);
        result.setAttribute(2, true);
        result.setName(this.getName());
        return result;
    }
}

