/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.filesystem;

import java.net.URI;
import java.util.logging.Logger;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.editors.text.ILocationProviderExtension;
import org.mule.alsp.helpers.LSUtils;

public class FileJarEntryEditorInput
implements IStorageEditorInput {
    private static final Logger LOG = Logger.getLogger(FileJarEntryEditorInput.class.getName());
    private IStorageEditorInput jarInput;

    public boolean equals(Object obj) {
        return this.jarInput.equals(obj);
    }

    public int hashCode() {
        return this.jarInput.hashCode();
    }

    public IPersistableElement getPersistable() {
        return this.jarInput.getPersistable();
    }

    public String getName() {
        return this.jarInput.getName();
    }

    public String getToolTipText() {
        return this.jarInput.getToolTipText();
    }

    public ImageDescriptor getImageDescriptor() {
        return this.jarInput.getImageDescriptor();
    }

    public boolean exists() {
        return this.jarInput.exists();
    }

    public <T> T getAdapter(Class<T> adapter) {
        JarEntryFile jarStorage;
        if (adapter == null || !ILocationProvider.class.isAssignableFrom(adapter)) {
            return null;
        }
        try {
            jarStorage = (JarEntryFile)this.getStorage();
        }
        catch (CoreException exc) {
            LOG.severe(exc.getMessage());
            return null;
        }
        String jarURIString = jarStorage.getPackageFragmentRoot().getPath().toString();
        String jarEntryURIString = jarStorage.getFullPath().toString();
        URI completeURI = null;
        completeURI = LSUtils.createArchiveURI(jarURIString, jarEntryURIString, true);
        return (T)new JarLocationProvider(completeURI);
    }

    public IStorage getStorage() throws CoreException {
        return this.jarInput.getStorage();
    }

    public String toString() {
        return this.jarInput.toString();
    }

    public FileJarEntryEditorInput(IStorageEditorInput jarInput) {
        this.jarInput = jarInput;
    }

    class JarLocationProvider
    implements ILocationProvider,
    ILocationProviderExtension {
        private URI uri;

        JarLocationProvider(URI uri) {
            this.uri = uri;
        }

        public URI getURI(Object element) {
            return this.uri;
        }

        public IPath getPath(Object element) {
            return null;
        }
    }
}

